/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.management;

import java.util.List;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.management.Management;

public final class ExecutionEvent {
    private final Object impl;

    ExecutionEvent(Object impl) {
        this.impl = impl;
    }

    public SourceSection getLocation() {
        return Management.IMPL.getExecutionEventLocation(this.impl);
    }

    public String getRootName() {
        return Management.IMPL.getExecutionEventRootName(this.impl);
    }

    public List<Value> getInputValues() {
        return Management.IMPL.getExecutionEventInputValues(this.impl);
    }

    public Value getReturnValue() {
        return Management.IMPL.getExecutionEventReturnValue(this.impl);
    }

    public PolyglotException getException() {
        return Management.IMPL.getExecutionEventException(this.impl);
    }

    public boolean isExpression() {
        return Management.IMPL.isExecutionEventExpression(this.impl);
    }

    public boolean isStatement() {
        return Management.IMPL.isExecutionEventStatement(this.impl);
    }

    public boolean isRoot() {
        return Management.IMPL.isExecutionEventRoot(this.impl);
    }

    public String toString() {
        PolyglotException exception;
        Value returnValue;
        List<Value> inputValues;
        String rootName;
        StringBuilder b = new StringBuilder("ExecutionEvent[");
        if (this.isRoot()) {
            b.append("root").append(", ");
        }
        if (this.isStatement()) {
            b.append("statement").append(", ");
        }
        if (this.isExpression()) {
            b.append("expression").append(", ");
        }
        if ((rootName = this.getRootName()) != null) {
            b.append("rootName=").append(rootName).append(", ");
        }
        if ((inputValues = this.getInputValues()) != null) {
            b.append("inputValues=").append(inputValues).append(", ");
        }
        if ((returnValue = this.getReturnValue()) != null) {
            b.append("returnValue=").append(returnValue).append(", ");
        }
        if ((exception = this.getException()) != null) {
            b.append("exception=").append(exception).append(", ");
        }
        b.append("location=").append(this.getLocation());
        b.append("]");
        return b.toString();
    }
}

