/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltins;
import com.oracle.truffle.js.builtins.helper.ReplaceStringParser;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsRegExpNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToRegExpNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=StringPrototypeBuiltins.class)
public final class StringPrototypeBuiltinsFactory {

    @GeneratedBy(value=StringPrototypeBuiltins.CreateHTMLNode.class)
    static final class CreateHTMLNodeGen
    extends StringPrototypeBuiltins.CreateHTMLNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private RequireObjectCoercibleNode requireObjectCoercibleNode_;
        @Node.Child
        private JSToStringNode toStringNode_;

        private CreateHTMLNodeGen(JSContext context, JSBuiltin builtin, String tag, String attribute, JavaScriptNode[] arguments) {
            super(context, builtin, tag, attribute);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.createHTML(arguments0Value_, arguments1Value_, this.requireObjectCoercibleNode_, this.toStringNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.requireObjectCoercibleNode_ = (RequireObjectCoercibleNode)super.insert((Node)RequireObjectCoercibleNode.create());
                this.toStringNode_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.createHTML(arguments0Value, arguments1Value, this.requireObjectCoercibleNode_, this.toStringNode_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "createHTML";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.requireObjectCoercibleNode_, this.toStringNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.CreateHTMLNode create(JSContext context, JSBuiltin builtin, String tag, String attribute, JavaScriptNode[] arguments) {
            return new CreateHTMLNodeGen(context, builtin, tag, attribute, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.CreateStringIteratorNode.class)
    public static final class CreateStringIteratorNodeGen
    extends StringPrototypeBuiltins.CreateStringIteratorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private RequireObjectCoercibleNode coerce_requireObjectCoercibleNode_;
        @Node.Child
        private JSToStringNode coerce_toStringNode_;

        private CreateStringIteratorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                return this.doString(frameValue, arguments0Value__);
            }
            if ((state & 2) != 0 && !JSGuards.isString(arguments0Value_)) {
                return this.doCoerce(frameValue, arguments0Value_, this.coerce_requireObjectCoercibleNode_, this.coerce_toStringNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    state |= stringCast0 << 2;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doString(frameValue, arguments0Value_);
                    return dynamicObject;
                }
                if (!JSGuards.isString(arguments0Value)) {
                    this.coerce_requireObjectCoercibleNode_ = (RequireObjectCoercibleNode)super.insert((Node)RequireObjectCoercibleNode.create());
                    this.coerce_toStringNode_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doCoerce(frameValue, arguments0Value, this.coerce_requireObjectCoercibleNode_, this.coerce_toStringNode_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 3 & (state & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doString";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doCoerce";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.coerce_requireObjectCoercibleNode_, this.coerce_toStringNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.CreateStringIteratorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CreateStringIteratorNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringPadNode.class)
    public static final class JSStringPadNodeGen
    extends StringPrototypeBuiltins.JSStringPadNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToStringNode toString2Node_;

        private JSStringPadNodeGen(JSContext context, JSBuiltin builtin, boolean atStart, JavaScriptNode[] arguments) {
            super(context, builtin, atStart);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.pad(arguments0Value_, arguments1Value__, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    this.toString2Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.pad(arguments0Value, arguments1Value_, this.toString2Node_);
                    return string;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "pad";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.toString2Node_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringPadNode create(JSContext context, JSBuiltin builtin, boolean atStart, JavaScriptNode[] arguments) {
            return new JSStringPadNodeGen(context, builtin, atStart, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringNormalizeNode.class)
    public static final class JSStringNormalizeNodeGen
    extends StringPrototypeBuiltins.JSStringNormalizeNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringNormalizeNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.normalize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "normalize";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringNormalizeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringNormalizeNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringCodePointAtNode.class)
    public static final class JSStringCodePointAtNodeGen
    extends StringPrototypeBuiltins.JSStringCodePointAtNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringCodePointAtNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.codePointAt(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "codePointAt";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringCodePointAtNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringCodePointAtNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringRepeatNode.class)
    public static final class JSStringRepeatNodeGen
    extends StringPrototypeBuiltins.JSStringRepeatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToNumberNode toNumberNode_;

        private JSStringRepeatNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.repeat(arguments0Value_, arguments1Value_, this.toNumberNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toNumberNode_ = (JSToNumberNode)super.insert((Node)JSToNumberNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.repeat(arguments0Value, arguments1Value, this.toNumberNode_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "repeat";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToNumberNode>> cached = new ArrayList<List<JSToNumberNode>>();
                cached.add(Arrays.asList(this.toNumberNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringRepeatNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringRepeatNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringIncludesNode.class)
    public static final class JSStringIncludesNodeGen
    extends StringPrototypeBuiltins.JSStringIncludesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToStringNode toString2Node_;
        @Node.Child
        private IsRegExpNode isRegExpNode_;

        private JSStringIncludesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                return this.includes(arguments0Value_, arguments1Value_, arguments2Value_, this.toString2Node_, this.isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                return this.includes(arguments0Value_, arguments1Value_, arguments2Value_, this.toString2Node_, this.isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toString2Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                this.isRegExpNode_ = (IsRegExpNode)super.insert((Node)IsRegExpNode.create(this.getContext()));
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.includes(arguments0Value, arguments1Value, arguments2Value, this.toString2Node_, this.isRegExpNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "includes";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.toString2Node_, this.isRegExpNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringIncludesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringIncludesNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringEndsWithNode.class)
    public static final class JSStringEndsWithNodeGen
    extends StringPrototypeBuiltins.JSStringEndsWithNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToStringNode toString2Node_;
        @Node.Child
        private IsRegExpNode isRegExpNode_;

        private JSStringEndsWithNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                return this.endsWith(arguments0Value_, arguments1Value_, arguments2Value_, this.toString2Node_, this.isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                return this.endsWith(arguments0Value_, arguments1Value_, arguments2Value_, this.toString2Node_, this.isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toString2Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                this.isRegExpNode_ = (IsRegExpNode)super.insert((Node)IsRegExpNode.create(this.getContext()));
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.endsWith(arguments0Value, arguments1Value, arguments2Value, this.toString2Node_, this.isRegExpNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "endsWith";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.toString2Node_, this.isRegExpNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringEndsWithNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringEndsWithNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringStartsWithNode.class)
    public static final class JSStringStartsWithNodeGen
    extends StringPrototypeBuiltins.JSStringStartsWithNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToStringNode startsWith_toString2Node_;
        @Node.Child
        private IsRegExpNode startsWith_isRegExpNode_;

        private JSStringStartsWithNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                if (JSTypesGen.isImplicitString((state & 0x3C0) >>> 6, arguments1Value_)) {
                    DynamicObject arguments2Value__;
                    String arguments1Value__ = JSTypesGen.asImplicitString((state & 0x3C0) >>> 6, arguments1Value_);
                    if (JSTypes.isDynamicObject(arguments2Value_) && JSGuards.isUndefined(arguments2Value__ = (DynamicObject)arguments2Value_)) {
                        return this.startsWithString(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                }
            }
            if ((state & 2) != 0) {
                return this.startsWith(arguments0Value_, arguments1Value_, arguments2Value_, this.startsWith_toString2Node_, this.startsWith_isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                if (JSTypesGen.isImplicitString((state & 0x3C0) >>> 6, arguments1Value_)) {
                    DynamicObject arguments2Value__;
                    String arguments1Value__ = JSTypesGen.asImplicitString((state & 0x3C0) >>> 6, arguments1Value_);
                    if (JSTypes.isDynamicObject(arguments2Value_) && JSGuards.isUndefined(arguments2Value__ = (DynamicObject)arguments2Value_)) {
                        return this.startsWithString(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                }
            }
            if ((state & 2) != 0) {
                return this.startsWith(arguments0Value_, arguments1Value_, arguments2Value_, this.startsWith_toString2Node_, this.startsWith_isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        DynamicObject arguments2Value_;
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (JSTypes.isDynamicObject(arguments2Value) && JSGuards.isUndefined(arguments2Value_ = (DynamicObject)arguments2Value)) {
                            state |= stringCast0 << 2;
                            state |= stringCast1 << 6;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            boolean bl = this.startsWithString(arguments0Value_, arguments1Value_, arguments2Value_);
                            return bl;
                        }
                    }
                }
                this.startsWith_toString2Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                this.startsWith_isRegExpNode_ = (IsRegExpNode)super.insert((Node)IsRegExpNode.create(this.getContext()));
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.startsWith(arguments0Value, arguments1Value, arguments2Value, this.startsWith_toString2Node_, this.startsWith_isRegExpNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 3 & (state & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "startsWithString";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "startsWith";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.startsWith_toString2Node_, this.startsWith_isRegExpNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringStartsWithNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringStartsWithNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSliceNode.class)
    public static final class JSStringSliceNodeGen
    extends StringPrototypeBuiltins.JSStringSliceNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private JSStringSliceNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 4) == 0 && (state & 7) != 0) {
                return this.execute_int_int0(frameValue, state);
            }
            return this.execute_generic1(frameValue, state);
        }

        private Object execute_int_int0(VirtualFrame frameValue, int state) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                return this.sliceString(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            if ((state & 2) != 0) {
                return this.sliceObject(arguments0Value_, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic1(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 3) != 0 && arguments1Value_ instanceof Integer) {
                int arguments1Value__ = (Integer)arguments1Value_;
                if (arguments2Value_ instanceof Integer) {
                    int arguments2Value__ = (Integer)arguments2Value_;
                    if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                        String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                        return this.sliceString(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                    if ((state & 2) != 0) {
                        return this.sliceObject(arguments0Value_, arguments1Value__, arguments2Value__);
                    }
                }
            }
            if ((state & 4) != 0) {
                return this.slice(arguments0Value_, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (arguments1Value instanceof Integer) {
                    int arguments1Value_ = (Integer)arguments1Value;
                    if (arguments2Value instanceof Integer) {
                        int stringCast0;
                        int arguments2Value_ = (Integer)arguments2Value;
                        if ((exclude & 1) == 0 && (stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                            String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                            state |= stringCast0 << 3;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            String string = this.sliceString(arguments0Value_, arguments1Value_, arguments2Value_);
                            return string;
                        }
                        if ((exclude & 2) == 0) {
                            this.exclude_ = exclude |= 1;
                            state &= 0xFFFFFFFE;
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            String string = this.sliceObject(arguments0Value, arguments1Value_, arguments2Value_);
                            return string;
                        }
                    }
                }
                this.exclude_ = exclude |= 3;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.slice(arguments0Value, arguments1Value, arguments2Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "sliceString";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "sliceObject";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s;
            s = new Object[3];
            s[0] = "slice";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringSliceNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSliceNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringLocaleCompareIntlNode.class)
    public static final class JSStringLocaleCompareIntlNodeGen
    extends StringPrototypeBuiltins.JSStringLocaleCompareIntlNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @Node.Child
        private JavaScriptNode arguments3_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToStringNode toString2Node_;

        private JSStringLocaleCompareIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if (state != 0) {
                return this.localeCompare(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if (state != 0) {
                return this.localeCompare(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toString2Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.localeCompare(arguments0Value, arguments1Value, arguments2Value, arguments3Value, this.toString2Node_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "localeCompare";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.toString2Node_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringLocaleCompareIntlNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringLocaleCompareIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringLocaleCompareNode.class)
    public static final class JSStringLocaleCompareNodeGen
    extends StringPrototypeBuiltins.JSStringLocaleCompareNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToStringNode toString2Node_;

        private JSStringLocaleCompareNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.localeCompare(arguments0Value_, arguments1Value_, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.localeCompare(arguments0Value_, arguments1Value_, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toString2Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.localeCompare(arguments0Value, arguments1Value, this.toString2Node_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "localeCompare";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.toString2Node_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringLocaleCompareNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringLocaleCompareNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringTrimRightNode.class)
    public static final class JSStringTrimRightNodeGen
    extends StringPrototypeBuiltins.JSStringTrimRightNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private JSStringTrimRightNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.trimRight(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "trimRight";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringTrimRightNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringTrimRightNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringTrimLeftNode.class)
    public static final class JSStringTrimLeftNodeGen
    extends StringPrototypeBuiltins.JSStringTrimLeftNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private JSStringTrimLeftNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.trimLeft(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "trimLeft";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringTrimLeftNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringTrimLeftNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringTrimNode.class)
    public static final class JSStringTrimNodeGen
    extends StringPrototypeBuiltins.JSStringTrimNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSTrimWhitespaceNode trimWhitespaceNode_;

        private JSStringTrimNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0) {
                return this.trimObject(arguments0Value_, this.trimWhitespaceNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.trimWhitespaceNode_ = (JSTrimWhitespaceNode)super.insert((Node)JSTrimWhitespaceNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.trimObject(arguments0Value, this.trimWhitespaceNode_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "trimObject";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSTrimWhitespaceNode>> cached = new ArrayList<List<JSTrimWhitespaceNode>>();
                cached.add(Arrays.asList(this.trimWhitespaceNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringTrimNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringTrimNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringMatchES5Node.class)
    public static final class JSStringMatchES5NodeGen
    extends StringPrototypeBuiltins.JSStringMatchES5Node
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringMatchES5NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.matchRegExpNotGlobal(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "matchRegExpNotGlobal";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringMatchES5Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringMatchES5NodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringMatchNode.class)
    public static final class JSStringMatchNodeGen
    extends StringPrototypeBuiltins.JSStringMatchNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSStringMatchNodeGen(JSContext context, JSBuiltin builtin, boolean matchAll, JavaScriptNode[] arguments) {
            super(context, builtin, matchAll);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.match(arguments0Value_, arguments1Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (arguments1Value instanceof Object[]) {
                Object[] arguments1Value_ = (Object[])arguments1Value;
                this.state_ = state |= 1;
                return this.match(arguments0Value, arguments1Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "match";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringMatchNode create(JSContext context, JSBuiltin builtin, boolean matchAll, JavaScriptNode[] arguments) {
            return new JSStringMatchNodeGen(context, builtin, matchAll, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstrNode.class)
    public static final class JSStringSubstrNodeGen
    extends StringPrototypeBuiltins.JSStringSubstrNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private JSStringSubstrNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.execute_int_int0(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.execute_int1(frameValue, state);
            }
            return this.execute_generic2(frameValue, state);
        }

        private Object execute_int_int0(VirtualFrame frameValue, int state) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            if (JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                return this.substrInt(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_int1(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            assert ((state & 2) != 0);
            if (JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                if (JSGuards.isUndefined(arguments2Value_)) {
                    return this.substrLenUndef(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 3) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state & 1) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.substrInt(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                    if ((state & 2) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                        return this.substrLenUndef(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                }
            }
            if ((state & 4) != 0) {
                return this.substr(arguments0Value_, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if ((exclude & 1) == 0 && arguments2Value instanceof Integer) {
                            int arguments2Value_ = (Integer)arguments2Value;
                            state |= stringCast0 << 3;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            String string = this.substrInt(arguments0Value_, arguments1Value_, arguments2Value_);
                            return string;
                        }
                        if ((exclude & 2) == 0 && JSGuards.isUndefined(arguments2Value)) {
                            state |= stringCast0 << 3;
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            String string = this.substrLenUndef(arguments0Value_, arguments1Value_, arguments2Value);
                            return string;
                        }
                    }
                }
                this.exclude_ = exclude |= 3;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.substr(arguments0Value, arguments1Value, arguments2Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "substrInt";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "substrLenUndef";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s;
            s = new Object[3];
            s[0] = "substr";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringSubstrNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSubstrNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSearchES5Node.class)
    public static final class JSStringSearchES5NodeGen
    extends StringPrototypeBuiltins.JSStringSearchES5Node
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToRegExpNode toRegExpNode_;

        private JSStringSearchES5NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.search(arguments0Value_, arguments1Value__, this.toRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.search(arguments0Value_, arguments1Value__, this.toRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    this.toRegExpNode_ = (JSToRegExpNode)super.insert((Node)JSToRegExpNode.create(this.getContext()));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.search(arguments0Value, arguments1Value_, this.toRegExpNode_);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "search";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToRegExpNode>> cached = new ArrayList<List<JSToRegExpNode>>();
                cached.add(Arrays.asList(this.toRegExpNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringSearchES5Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSearchES5NodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSearchNode.class)
    public static final class JSStringSearchNodeGen
    extends StringPrototypeBuiltins.JSStringSearchNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSStringSearchNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.search(arguments0Value_, arguments1Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (arguments1Value instanceof Object[]) {
                Object[] arguments1Value_ = (Object[])arguments1Value;
                this.state_ = state |= 1;
                return this.search(arguments0Value, arguments1Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "search";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringSearchNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSearchNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToUpperCaseNode.class)
    public static final class JSStringToUpperCaseNodeGen
    extends StringPrototypeBuiltins.JSStringToUpperCaseNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private JSStringToUpperCaseNodeGen(JSContext context, JSBuiltin builtin, boolean locale, JavaScriptNode[] arguments) {
            super(context, builtin, locale);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.toUpperCase(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "toUpperCase";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringToUpperCaseNode create(JSContext context, JSBuiltin builtin, boolean locale, JavaScriptNode[] arguments) {
            return new JSStringToUpperCaseNodeGen(context, builtin, locale, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToLocaleUpperCaseIntlNode.class)
    public static final class JSStringToLocaleUpperCaseIntlNodeGen
    extends StringPrototypeBuiltins.JSStringToLocaleUpperCaseIntlNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringToLocaleUpperCaseIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.toDesiredCase(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "toDesiredCase";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringToLocaleUpperCaseIntlNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringToLocaleUpperCaseIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToLocaleLowerCaseIntlNode.class)
    public static final class JSStringToLocaleLowerCaseIntlNodeGen
    extends StringPrototypeBuiltins.JSStringToLocaleLowerCaseIntlNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringToLocaleLowerCaseIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.toDesiredCase(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "toDesiredCase";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringToLocaleLowerCaseIntlNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringToLocaleLowerCaseIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToLocaleXCaseIntl.class)
    public static final class JSStringToLocaleXCaseIntlNodeGen
    extends StringPrototypeBuiltins.JSStringToLocaleXCaseIntl
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringToLocaleXCaseIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.toDesiredCase(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "toDesiredCase";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringToLocaleXCaseIntl create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringToLocaleXCaseIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToLowerCaseNode.class)
    public static final class JSStringToLowerCaseNodeGen
    extends StringPrototypeBuiltins.JSStringToLowerCaseNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private JSStringToLowerCaseNodeGen(JSContext context, JSBuiltin builtin, boolean locale, JavaScriptNode[] arguments) {
            super(context, builtin, locale);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.toLowerCase(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "toLowerCase";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringToLowerCaseNode create(JSContext context, JSBuiltin builtin, boolean locale, JavaScriptNode[] arguments) {
            return new JSStringToLowerCaseNodeGen(context, builtin, locale, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToStringNode.class)
    public static final class JSStringToStringNodeGen
    extends StringPrototypeBuiltins.JSStringToStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private StringPrototypeBuiltins.JSStringToStringNode toString0_nestedToString_;

        private JSStringToStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        protected String executeString(Object arguments0Value) {
            Object arguments0Value_;
            int state = this.state_;
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                return this.toString((DynamicObject)arguments0Value_, this.toString0_nestedToString_);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x78) >>> 3, arguments0Value)) {
                arguments0Value_ = JSTypesGen.asImplicitCharSequence((state & 0x78) >>> 3, arguments0Value);
                return this.toString((CharSequence)arguments0Value_);
            }
            if ((state & 4) != 0 && !JSGuards.isString(arguments0Value) && !JSGuards.isJSString(arguments0Value)) {
                return this.toString(arguments0Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSString(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.toString((DynamicObject)arguments0Value__, this.toString0_nestedToString_);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x78) >>> 3, arguments0Value_)) {
                arguments0Value__ = JSTypesGen.asImplicitCharSequence((state & 0x78) >>> 3, arguments0Value_);
                return this.toString((CharSequence)arguments0Value__);
            }
            if ((state & 4) != 0 && !JSGuards.isString(arguments0Value_) && !JSGuards.isJSString(arguments0Value_)) {
                return this.toString(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.toString0_nestedToString_ = (StringPrototypeBuiltins.JSStringToStringNode)super.insert((Node)StringPrototypeBuiltins.JSStringToStringNode.createStringToString(this.getContext()));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.toString(arguments0Value_, this.toString0_nestedToString_);
                    return string;
                }
                int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(arguments0Value);
                if (charSequenceCast0 != 0) {
                    CharSequence arguments0Value_2 = JSTypesGen.asImplicitCharSequence(charSequenceCast0, arguments0Value);
                    state |= charSequenceCast0 << 3;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    String string = this.toString(arguments0Value_2);
                    return string;
                }
                if (!JSGuards.isString(arguments0Value) && !JSGuards.isJSString(arguments0Value)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    String string = this.toString(arguments0Value);
                    return string;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "toString";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<StringPrototypeBuiltins.JSStringToStringNode>> cached = new ArrayList<List<StringPrototypeBuiltins.JSStringToStringNode>>();
                cached.add(Arrays.asList(this.toString0_nestedToString_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "toString";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "toString";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringToStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringToStringNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceES5Node.class)
    public static final class JSStringReplaceES5NodeGen
    extends StringPrototypeBuiltins.JSStringReplaceES5Node
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;

        private JSStringReplaceES5NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            return this.replace(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "replace";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringReplaceES5Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringReplaceES5NodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceAllNode.class)
    public static final class JSStringReplaceAllNodeGen
    extends StringPrototypeBuiltins.JSStringReplaceAllNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private ReplaceStringCachedData replaceStringCached_cache;

        private JSStringReplaceAllNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 7) != 0) {
                if ((state & 3) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments1Value_);
                    if (JSTypesGen.isImplicitString((state & 0x780) >>> 7, arguments2Value_)) {
                        String arguments2Value__ = JSTypesGen.asImplicitString((state & 0x780) >>> 7, arguments2Value_);
                        if ((state & 1) != 0) {
                            ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                            while (s1_ != null) {
                                if (s1_.cachedReplaceValue_.equals(arguments2Value__)) {
                                    return this.replaceStringCached(arguments0Value_, arguments1Value__, arguments2Value__, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state & 2) != 0) {
                            return this.replaceString(arguments0Value_, arguments1Value__, arguments2Value__);
                        }
                    }
                }
                if ((state & 4) != 0) {
                    return this.replaceGeneric(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                if (stringCast1 != 0) {
                    String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                    int stringCast2 = JSTypesGen.specializeImplicitString(arguments2Value);
                    if (stringCast2 != 0) {
                        String arguments2Value_ = JSTypesGen.asImplicitString(stringCast2, arguments2Value);
                        if ((exclude & 1) == 0) {
                            int count1_ = 0;
                            ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                            if ((state & 1) != 0) {
                                while (s1_ != null && !s1_.cachedReplaceValue_.equals(arguments2Value_)) {
                                    s1_ = s1_.next_;
                                    ++count1_;
                                }
                            }
                            if (s1_ == null) {
                                if (count1_ < 3) {
                                    s1_ = new ReplaceStringCachedData(this.replaceStringCached_cache);
                                    s1_.cachedReplaceValue_ = arguments2Value_;
                                    s1_.cachedParsedReplaceValue_ = StringPrototypeBuiltins.JSStringReplaceBaseNode.parseReplaceValue(arguments2Value_);
                                    this.replaceStringCached_cache = s1_;
                                    state |= stringCast1 << 3;
                                    state |= stringCast2 << 7;
                                    this.state_ = state |= 1;
                                }
                            } else {
                                state |= stringCast1 << 3;
                                state |= stringCast2 << 7;
                                this.state_ = state |= 1;
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                Object object = this.replaceStringCached(arguments0Value, arguments1Value_, arguments2Value_, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_);
                                return object;
                            }
                        }
                        if ((exclude & 2) == 0) {
                            this.exclude_ = exclude |= 1;
                            this.replaceStringCached_cache = null;
                            state &= 0xFFFFFFFE;
                            state |= stringCast1 << 3;
                            state |= stringCast2 << 7;
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.replaceString(arguments0Value, arguments1Value_, arguments2Value_);
                            return object;
                        }
                    }
                }
                this.exclude_ = exclude |= 3;
                this.replaceStringCached_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.replaceGeneric(arguments0Value, arguments1Value, arguments2Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ReplaceStringCachedData s1_;
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0 && ((s1_ = this.replaceStringCached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "replaceStringCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Serializable>> cached = new ArrayList<List<Serializable>>();
                ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "replaceString";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s;
            s = new Object[3];
            s[0] = "replaceGeneric";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringReplaceAllNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringReplaceAllNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceAllNode.class)
        private static final class ReplaceStringCachedData {
            @CompilerDirectives.CompilationFinal
            ReplaceStringCachedData next_;
            @CompilerDirectives.CompilationFinal
            String cachedReplaceValue_;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            ReplaceStringParser.Token[] cachedParsedReplaceValue_;

            ReplaceStringCachedData(ReplaceStringCachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceNode.class)
    public static final class JSStringReplaceNodeGen
    extends StringPrototypeBuiltins.JSStringReplaceNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private ReplaceStringCachedData replaceStringCached_cache;

        private JSStringReplaceNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 7) != 0) {
                if ((state & 3) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments1Value_);
                    if (JSTypesGen.isImplicitString((state & 0x780) >>> 7, arguments2Value_)) {
                        String arguments2Value__ = JSTypesGen.asImplicitString((state & 0x780) >>> 7, arguments2Value_);
                        if ((state & 1) != 0) {
                            ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                            while (s1_ != null) {
                                if (s1_.cachedReplaceValue_.equals(arguments2Value__)) {
                                    return this.replaceStringCached(arguments0Value_, arguments1Value__, arguments2Value__, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state & 2) != 0) {
                            return this.replaceString(arguments0Value_, arguments1Value__, arguments2Value__);
                        }
                    }
                }
                if ((state & 4) != 0) {
                    return this.replaceGeneric(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                if (stringCast1 != 0) {
                    String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                    int stringCast2 = JSTypesGen.specializeImplicitString(arguments2Value);
                    if (stringCast2 != 0) {
                        String arguments2Value_ = JSTypesGen.asImplicitString(stringCast2, arguments2Value);
                        if ((exclude & 1) == 0) {
                            int count1_ = 0;
                            ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                            if ((state & 1) != 0) {
                                while (s1_ != null && !s1_.cachedReplaceValue_.equals(arguments2Value_)) {
                                    s1_ = s1_.next_;
                                    ++count1_;
                                }
                            }
                            if (s1_ == null) {
                                if (count1_ < 3) {
                                    s1_ = new ReplaceStringCachedData(this.replaceStringCached_cache);
                                    s1_.cachedReplaceValue_ = arguments2Value_;
                                    s1_.cachedParsedReplaceValue_ = StringPrototypeBuiltins.JSStringReplaceBaseNode.parseReplaceValue(arguments2Value_);
                                    this.replaceStringCached_cache = s1_;
                                    state |= stringCast1 << 3;
                                    state |= stringCast2 << 7;
                                    this.state_ = state |= 1;
                                }
                            } else {
                                state |= stringCast1 << 3;
                                state |= stringCast2 << 7;
                                this.state_ = state |= 1;
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                Object object = this.replaceStringCached(arguments0Value, arguments1Value_, arguments2Value_, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_);
                                return object;
                            }
                        }
                        if ((exclude & 2) == 0) {
                            this.exclude_ = exclude |= 1;
                            this.replaceStringCached_cache = null;
                            state &= 0xFFFFFFFE;
                            state |= stringCast1 << 3;
                            state |= stringCast2 << 7;
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.replaceString(arguments0Value, arguments1Value_, arguments2Value_);
                            return object;
                        }
                    }
                }
                this.exclude_ = exclude |= 3;
                this.replaceStringCached_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.replaceGeneric(arguments0Value, arguments1Value, arguments2Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ReplaceStringCachedData s1_;
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0 && ((s1_ = this.replaceStringCached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "replaceStringCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Serializable>> cached = new ArrayList<List<Serializable>>();
                ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "replaceString";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s;
            s = new Object[3];
            s[0] = "replaceGeneric";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringReplaceNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringReplaceNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceNode.class)
        private static final class ReplaceStringCachedData {
            @CompilerDirectives.CompilationFinal
            ReplaceStringCachedData next_;
            @CompilerDirectives.CompilationFinal
            String cachedReplaceValue_;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            ReplaceStringParser.Token[] cachedParsedReplaceValue_;

            ReplaceStringCachedData(ReplaceStringCachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringConcatNode.class)
    public static final class JSStringConcatNodeGen
    extends StringPrototypeBuiltins.JSStringConcatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToStringNode toString2Node_;

        private JSStringConcatNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.concat(arguments0Value_, arguments1Value__, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    this.toString2Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.concat(arguments0Value, arguments1Value_, this.toString2Node_);
                    return string;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "concat";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.toString2Node_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringConcatNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringConcatNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSplitNode.class)
    public static final class JSStringSplitNodeGen
    extends StringPrototypeBuiltins.JSStringSplitNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;

        private JSStringSplitNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            return this.splitGeneric(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "splitGeneric";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringSplitNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSplitNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringLastIndexOfNode.class)
    public static final class JSStringLastIndexOfNodeGen
    extends StringPrototypeBuiltins.JSStringLastIndexOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LastIndexOfData lastIndexOf_cache;

        private JSStringLastIndexOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            LastIndexOfData s2_;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                if (JSTypesGen.isImplicitString((state & 0x3C0) >>> 6, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state & 0x3C0) >>> 6, arguments1Value_);
                    if (JSTypes.isDynamicObject(arguments2Value_)) {
                        DynamicObject arguments2Value__ = (DynamicObject)arguments2Value_;
                        if (this.isStringLength1(arguments1Value__) && JSGuards.isUndefined(arguments2Value__)) {
                            return this.lastIndexOfString(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                }
            }
            if ((state & 2) != 0 && (s2_ = this.lastIndexOf_cache) != null) {
                return this.lastIndexOf(arguments0Value_, arguments1Value_, arguments2Value_, s2_.toString2Node_, s2_.toNumberNode_, s2_.posNaN_, s2_.searchStrZero_, s2_.searchStrOne_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            LastIndexOfData s2_;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                if (JSTypesGen.isImplicitString((state & 0x3C0) >>> 6, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state & 0x3C0) >>> 6, arguments1Value_);
                    if (JSTypes.isDynamicObject(arguments2Value_)) {
                        DynamicObject arguments2Value__ = (DynamicObject)arguments2Value_;
                        if (this.isStringLength1(arguments1Value__) && JSGuards.isUndefined(arguments2Value__)) {
                            return this.lastIndexOfString(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                }
            }
            if ((state & 2) != 0 && (s2_ = this.lastIndexOf_cache) != null) {
                return this.lastIndexOf(arguments0Value_, arguments1Value_, arguments2Value_, s2_.toString2Node_, s2_.toNumberNode_, s2_.posNaN_, s2_.searchStrZero_, s2_.searchStrOne_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                int stringCast0;
                if (exclude == 0 && (stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (JSTypes.isDynamicObject(arguments2Value)) {
                            DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                            if (this.isStringLength1(arguments1Value_) && JSGuards.isUndefined(arguments2Value_)) {
                                state |= stringCast0 << 2;
                                state |= stringCast1 << 6;
                                this.state_ = state |= 1;
                                lock.unlock();
                                hasLock = false;
                                int n = this.lastIndexOfString(arguments0Value_, arguments1Value_, arguments2Value_);
                                return n;
                            }
                        }
                    }
                }
                LastIndexOfData s2_ = (LastIndexOfData)super.insert((Node)new LastIndexOfData());
                s2_.toString2Node_ = s2_.insertAccessor(JSToStringNode.create());
                s2_.toNumberNode_ = s2_.insertAccessor(JSToNumberNode.create());
                s2_.posNaN_ = ConditionProfile.createBinaryProfile();
                s2_.searchStrZero_ = ConditionProfile.createBinaryProfile();
                s2_.searchStrOne_ = ConditionProfile.createBinaryProfile();
                this.lastIndexOf_cache = s2_;
                this.exclude_ = exclude |= 1;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                int n = this.lastIndexOf(arguments0Value, arguments1Value, arguments2Value, s2_.toString2Node_, s2_.toNumberNode_, s2_.posNaN_, s2_.searchStrZero_, s2_.searchStrOne_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 3 & (state & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "lastIndexOfString";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "lastIndexOf";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                LastIndexOfData s2_ = this.lastIndexOf_cache;
                if (s2_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s2_.toString2Node_, s2_.toNumberNode_, s2_.posNaN_, s2_.searchStrZero_, s2_.searchStrOne_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringLastIndexOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringLastIndexOfNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringLastIndexOfNode.class)
        private static final class LastIndexOfData
        extends Node {
            @Node.Child
            JSToStringNode toString2Node_;
            @Node.Child
            JSToNumberNode toNumberNode_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile posNaN_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile searchStrZero_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile searchStrOne_;

            LastIndexOfData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringIndexOfNode.class)
    public static final class JSStringIndexOfNodeGen
    extends StringPrototypeBuiltins.JSStringIndexOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private JSToStringNode indexOfGeneric_toString2Node_;

        private JSStringIndexOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 3) != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                    return this.indexOf(arguments0Value__, arguments1Value__);
                }
                if ((state & 2) != 0) {
                    return this.indexOfGeneric(arguments0Value_, arguments1Value__, this.indexOfGeneric_toString2Node_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 3) != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                    return this.indexOf(arguments0Value__, arguments1Value__);
                }
                if ((state & 2) != 0) {
                    return this.indexOfGeneric(arguments0Value_, arguments1Value__, this.indexOfGeneric_toString2Node_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (arguments1Value instanceof Object[]) {
                    int stringCast0;
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    if (exclude == 0 && (stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                        String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                        state |= stringCast0 << 2;
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        int n = this.indexOf(arguments0Value_, arguments1Value_);
                        return n;
                    }
                    this.indexOfGeneric_toString2Node_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    int n = this.indexOfGeneric(arguments0Value, arguments1Value_, this.indexOfGeneric_toString2Node_);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 3 & (state & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "indexOf";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "indexOfGeneric";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.indexOfGeneric_toString2Node_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringIndexOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringIndexOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstringNode.class)
    public static final class JSStringSubstringNodeGen
    extends StringPrototypeBuiltins.JSStringSubstringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private SubstringGenericData substringGeneric_cache;

        private JSStringSubstringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.execute_int_int0(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.execute_int1(frameValue, state);
            }
            return this.execute_generic2(frameValue, state);
        }

        private Object execute_int_int0(VirtualFrame frameValue, int state) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            if (JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                return this.substring(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_int1(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            assert ((state & 2) != 0);
            if (JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                if (JSGuards.isUndefined(arguments2Value_)) {
                    return this.substringStart(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            SubstringGenericData s3_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 3) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state & 1) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.substring(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                    if ((state & 2) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                        return this.substringStart(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                }
            }
            if ((state & 4) != 0 && (s3_ = this.substringGeneric_cache) != null) {
                return this.substringGeneric(arguments0Value_, arguments1Value_, arguments2Value_, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if ((exclude & 1) == 0 && arguments2Value instanceof Integer) {
                            int arguments2Value_ = (Integer)arguments2Value;
                            state |= stringCast0 << 3;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            String string = this.substring(arguments0Value_, arguments1Value_, arguments2Value_);
                            return string;
                        }
                        if ((exclude & 2) == 0 && JSGuards.isUndefined(arguments2Value)) {
                            state |= stringCast0 << 3;
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            String string = this.substringStart(arguments0Value_, arguments1Value_, arguments2Value);
                            return string;
                        }
                    }
                }
                SubstringGenericData s3_ = (SubstringGenericData)super.insert((Node)new SubstringGenericData());
                s3_.toNumberNode_ = s3_.insertAccessor(JSToNumberNode.create());
                s3_.toNumber2Node_ = s3_.insertAccessor(JSToNumberNode.create());
                s3_.startUndefined_ = ConditionProfile.createBinaryProfile();
                s3_.endUndefined_ = ConditionProfile.createBinaryProfile();
                this.substringGeneric_cache = s3_;
                this.exclude_ = exclude |= 3;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.substringGeneric(arguments0Value, arguments1Value, arguments2Value, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 7 & (state & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "substring";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "substringStart";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s;
            s = new Object[3];
            s[0] = "substringGeneric";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                SubstringGenericData s3_ = this.substringGeneric_cache;
                if (s3_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringSubstringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSubstringNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstringNode.Inlined.class)
        public static final class InlinedNodeGen
        extends StringPrototypeBuiltins.JSStringSubstringNode.Inlined
        implements Introspection.Provider {
            @Node.Child
            private JavaScriptNode arguments0_;
            @Node.Child
            private JavaScriptNode arguments1_;
            @Node.Child
            private JavaScriptNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private SubstringGenericData substringGeneric_cache;

            private InlinedNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                super(context, builtin);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            @Override
            public JavaScriptNode[] getArguments() {
                return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
            }

            @Override
            protected Object executeWithArguments(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                SubstringGenericData s3_;
                int state = this.state_;
                if ((state & 3) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value)) {
                    String arguments0Value_ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if ((state & 1) != 0 && arguments2Value instanceof Integer) {
                            int arguments2Value_ = (Integer)arguments2Value;
                            return this.substring(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                        if ((state & 2) != 0 && JSGuards.isUndefined(arguments2Value)) {
                            return this.substringStart(arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                }
                if ((state & 4) != 0 && (s3_ = this.substringGeneric_cache) != null) {
                    return this.substringGeneric(arguments0Value, arguments1Value, arguments2Value, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state = this.state_;
                if ((state & 6) == 0 && (state & 7) != 0) {
                    return this.execute_int_int0(frameValue, state);
                }
                if ((state & 5) == 0 && (state & 7) != 0) {
                    return this.execute_int1(frameValue, state);
                }
                return this.execute_generic2(frameValue, state);
            }

            private Object execute_int_int0(VirtualFrame frameValue, int state) {
                int arguments2Value_;
                int arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
                }
                assert ((state & 1) != 0);
                if (JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                    return this.substring(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            private Object execute_int1(VirtualFrame frameValue, int state) {
                int arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
                }
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                assert ((state & 2) != 0);
                if (JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                    if (JSGuards.isUndefined(arguments2Value_)) {
                        return this.substringStart(arguments0Value__, arguments1Value_, arguments2Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            private Object execute_generic2(VirtualFrame frameValue, int state) {
                SubstringGenericData s3_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                if ((state & 3) != 0 && JSTypesGen.isImplicitString((state & 0x78) >>> 3, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x78) >>> 3, arguments0Value_);
                    if (arguments1Value_ instanceof Integer) {
                        int arguments1Value__ = (Integer)arguments1Value_;
                        if ((state & 1) != 0 && arguments2Value_ instanceof Integer) {
                            int arguments2Value__ = (Integer)arguments2Value_;
                            return this.substring(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                        if ((state & 2) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                            return this.substringStart(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                }
                if ((state & 4) != 0 && (s3_ = this.substringGeneric_cache) != null) {
                    return this.substringGeneric(arguments0Value_, arguments1Value_, arguments2Value_, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                    if (stringCast0 != 0) {
                        String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                        if (arguments1Value instanceof Integer) {
                            int arguments1Value_ = (Integer)arguments1Value;
                            if (arguments2Value instanceof Integer) {
                                int arguments2Value_ = (Integer)arguments2Value;
                                state |= stringCast0 << 3;
                                this.state_ = state |= 1;
                                lock.unlock();
                                hasLock = false;
                                String string = this.substring(arguments0Value_, arguments1Value_, arguments2Value_);
                                return string;
                            }
                            if (JSGuards.isUndefined(arguments2Value)) {
                                state |= stringCast0 << 3;
                                this.state_ = state |= 2;
                                lock.unlock();
                                hasLock = false;
                                String string = this.substringStart(arguments0Value_, arguments1Value_, arguments2Value);
                                return string;
                            }
                        }
                    }
                    SubstringGenericData s3_ = (SubstringGenericData)super.insert((Node)new SubstringGenericData());
                    s3_.toNumberNode_ = s3_.insertAccessor(JSToNumberNode.create());
                    s3_.toNumber2Node_ = s3_.insertAccessor(JSToNumberNode.create());
                    s3_.startUndefined_ = ConditionProfile.createBinaryProfile();
                    s3_.endUndefined_ = ConditionProfile.createBinaryProfile();
                    this.substringGeneric_cache = s3_;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    String string = this.substringGeneric(arguments0Value, arguments1Value, arguments2Value, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
                    return string;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 7) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 7 & (state & 7) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public Introspection getIntrospectionData() {
                Object[] data = new Object[4];
                data[0] = 0;
                int state = this.state_;
                Object[] s = new Object[3];
                s[0] = "substring";
                s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[1] = s;
                s = new Object[3];
                s[0] = "substringStart";
                s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[2] = s;
                s = new Object[3];
                s[0] = "substringGeneric";
                if ((state & 4) != 0) {
                    s[1] = (byte)1;
                    ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                    SubstringGenericData s3_ = this.substringGeneric_cache;
                    if (s3_ != null) {
                        cached.add(Arrays.asList(new Cloneable[]{s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_}));
                    }
                    s[2] = cached;
                } else {
                    s[1] = (byte)0;
                }
                data[3] = s;
                return Introspection.Provider.create((Object[])data);
            }

            public static StringPrototypeBuiltins.JSStringSubstringNode.Inlined create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                return new InlinedNodeGen(context, builtin, arguments);
            }

            @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstringNode.Inlined.class)
            private static final class SubstringGenericData
            extends Node {
                @Node.Child
                JSToNumberNode toNumberNode_;
                @Node.Child
                JSToNumberNode toNumber2Node_;
                @CompilerDirectives.CompilationFinal
                ConditionProfile startUndefined_;
                @CompilerDirectives.CompilationFinal
                ConditionProfile endUndefined_;

                SubstringGenericData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstringNode.class)
        private static final class SubstringGenericData
        extends Node {
            @Node.Child
            JSToNumberNode toNumberNode_;
            @Node.Child
            JSToNumberNode toNumber2Node_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile startUndefined_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile endUndefined_;

            SubstringGenericData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringCharCodeAtNode.class)
    public static final class JSStringCharCodeAtNodeGen
    extends StringPrototypeBuiltins.JSStringCharCodeAtNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile charCodeAtLazyString_flatten_;
        @Node.Child
        private JSToNumberNode charCodeAtGeneric_toNumberNode_;

        private JSStringCharCodeAtNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 8) == 0 && (state & 0xF) != 0) {
                return this.execute_int0(frameValue, state);
            }
            return this.execute_generic1(frameValue, state);
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            if ((state & 1) != 0 && arguments0Value_ instanceof JSLazyString) {
                JSLazyString arguments0Value__ = (JSLazyString)arguments0Value_;
                return this.charCodeAtLazyString(arguments0Value__, arguments1Value_, this.charCodeAtLazyString_flatten_);
            }
            if ((state & 6) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value_);
                if ((state & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value_)) {
                    return this.charCodeAtInBounds(arguments0Value__, arguments1Value_);
                }
                if ((state & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value_)) {
                    return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic1(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 7) != 0 && arguments1Value_ instanceof Integer) {
                int arguments1Value__ = (Integer)arguments1Value_;
                if ((state & 1) != 0 && arguments0Value_ instanceof JSLazyString) {
                    JSLazyString arguments0Value__ = (JSLazyString)arguments0Value_;
                    return this.charCodeAtLazyString(arguments0Value__, arguments1Value__, this.charCodeAtLazyString_flatten_);
                }
                if ((state & 6) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value_);
                    if ((state & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value__)) {
                        return this.charCodeAtInBounds(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value__)) {
                        return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value__);
                    }
                }
            }
            if ((state & 8) != 0) {
                return this.charCodeAtGeneric(arguments0Value_, arguments1Value_, this.charCodeAtGeneric_toNumberNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            String arguments0Value__;
            int arguments1Value_;
            int state = this.state_;
            if ((state & 9) != 0) {
                return JSTypesGen.expectDouble(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
            }
            if ((state & 4) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value_) && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value_), arguments1Value_)) {
                return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            String arguments0Value__;
            int arguments1Value_;
            int state = this.state_;
            if ((state & 9) != 0) {
                return JSTypesGen.expectInteger(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value_) && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value_), arguments1Value_)) {
                return this.charCodeAtInBounds(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 0xD) == 0 && (state & 0xF) != 0) {
                    this.executeInt(frameValue);
                    return;
                }
                if ((state & 0xB) == 0 && (state & 0xF) != 0) {
                    this.executeDouble(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (arguments1Value instanceof Integer) {
                    int arguments1Value_ = (Integer)arguments1Value;
                    if ((exclude & 1) == 0 && arguments0Value instanceof JSLazyString) {
                        JSLazyString arguments0Value_ = (JSLazyString)arguments0Value;
                        this.charCodeAtLazyString_flatten_ = ConditionProfile.createBinaryProfile();
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.charCodeAtLazyString(arguments0Value_, arguments1Value_, this.charCodeAtLazyString_flatten_);
                        return object;
                    }
                    int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                    if (stringCast0 != 0) {
                        String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                        if ((exclude & 2) == 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                            state |= stringCast0 << 4;
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            Integer n = this.charCodeAtInBounds(arguments0Value_, arguments1Value_);
                            return n;
                        }
                        if ((exclude & 4) == 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                            state |= stringCast0 << 4;
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            Double d = this.charCodeAtOutOfBounds(arguments0Value_, arguments1Value_);
                            return d;
                        }
                    }
                }
                this.charCodeAtGeneric_toNumberNode_ = (JSToNumberNode)super.insert((Node)JSToNumberNode.create());
                this.exclude_ = exclude |= 7;
                state &= 0xFFFFFFF8;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Object object = this.charCodeAtGeneric(arguments0Value, arguments1Value, this.charCodeAtGeneric_toNumberNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 0xF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 0xF & (state & 0xF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "charCodeAtLazyString";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                cached.add(Arrays.asList(this.charCodeAtLazyString_flatten_));
                s[2] = cached;
            } else {
                s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "charCodeAtInBounds";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s;
            s = new Object[3];
            s[0] = "charCodeAtOutOfBounds";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[3] = s;
            s = new Object[3];
            s[0] = "charCodeAtGeneric";
            if ((state & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.charCodeAtGeneric_toNumberNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringCharCodeAtNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringCharCodeAtNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringCharCodeAtNode.Inlined.class)
        public static final class InlinedNodeGen
        extends StringPrototypeBuiltins.JSStringCharCodeAtNode.Inlined
        implements Introspection.Provider {
            @Node.Child
            private JavaScriptNode arguments0_;
            @Node.Child
            private JavaScriptNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile charCodeAtLazyString_flatten_;
            @Node.Child
            private JSToNumberNode charCodeAtGeneric_toNumberNode_;

            private InlinedNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                super(context, builtin);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public JavaScriptNode[] getArguments() {
                return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
            }

            @Override
            protected Object executeWithArguments(Object arguments0Value, Object arguments1Value) {
                int state = this.state_;
                if ((state & 7) != 0 && arguments1Value instanceof Integer) {
                    int arguments1Value_ = (Integer)arguments1Value;
                    if ((state & 1) != 0 && arguments0Value instanceof JSLazyString) {
                        JSLazyString arguments0Value_ = (JSLazyString)arguments0Value;
                        return this.charCodeAtLazyString(arguments0Value_, arguments1Value_, this.charCodeAtLazyString_flatten_);
                    }
                    if ((state & 6) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value)) {
                        String arguments0Value_ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value);
                        if ((state & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                            return this.charCodeAtInBounds(arguments0Value_, arguments1Value_);
                        }
                        if ((state & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                            return this.charCodeAtOutOfBounds(arguments0Value_, arguments1Value_);
                        }
                    }
                }
                if ((state & 8) != 0) {
                    return this.charCodeAtGeneric(arguments0Value, arguments1Value, this.charCodeAtGeneric_toNumberNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state = this.state_;
                if ((state & 8) == 0 && (state & 0xF) != 0) {
                    return this.execute_int0(frameValue, state);
                }
                return this.execute_generic1(frameValue, state);
            }

            private Object execute_int0(VirtualFrame frameValue, int state) {
                int arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.executeAndSpecialize(arguments0Value_, ex.getResult());
                }
                if ((state & 1) != 0 && arguments0Value_ instanceof JSLazyString) {
                    JSLazyString arguments0Value__ = (JSLazyString)arguments0Value_;
                    return this.charCodeAtLazyString(arguments0Value__, arguments1Value_, this.charCodeAtLazyString_flatten_);
                }
                if ((state & 6) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value_);
                    if ((state & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value_)) {
                        return this.charCodeAtInBounds(arguments0Value__, arguments1Value_);
                    }
                    if ((state & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value_)) {
                        return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object execute_generic1(VirtualFrame frameValue, int state) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if ((state & 7) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state & 1) != 0 && arguments0Value_ instanceof JSLazyString) {
                        JSLazyString arguments0Value__ = (JSLazyString)arguments0Value_;
                        return this.charCodeAtLazyString(arguments0Value__, arguments1Value__, this.charCodeAtLazyString_flatten_);
                    }
                    if ((state & 6) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value_)) {
                        String arguments0Value__ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value_);
                        if ((state & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value__)) {
                            return this.charCodeAtInBounds(arguments0Value__, arguments1Value__);
                        }
                        if ((state & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value__)) {
                            return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value__);
                        }
                    }
                }
                if ((state & 8) != 0) {
                    return this.charCodeAtGeneric(arguments0Value_, arguments1Value_, this.charCodeAtGeneric_toNumberNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                String arguments0Value__;
                int arguments1Value_;
                int state = this.state_;
                if ((state & 9) != 0) {
                    return JSTypesGen.expectDouble(this.execute(frameValue));
                }
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
                }
                if ((state & 4) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value_) && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value_), arguments1Value_)) {
                    return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
            }

            @Override
            public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                String arguments0Value__;
                int arguments1Value_;
                int state = this.state_;
                if ((state & 9) != 0) {
                    return JSTypesGen.expectInteger(this.execute(frameValue));
                }
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
                }
                if ((state & 2) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arguments0Value_) && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arguments0Value_), arguments1Value_)) {
                    return this.charCodeAtInBounds(arguments0Value__, arguments1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                int state = this.state_;
                try {
                    if ((state & 0xD) == 0 && (state & 0xF) != 0) {
                        this.executeInt(frameValue);
                        return;
                    }
                    if ((state & 0xB) == 0 && (state & 0xF) != 0) {
                        this.executeDouble(frameValue);
                        return;
                    }
                    this.execute(frameValue);
                    return;
                }
                catch (UnexpectedResultException ex) {
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (arguments0Value instanceof JSLazyString) {
                            JSLazyString arguments0Value_ = (JSLazyString)arguments0Value;
                            this.charCodeAtLazyString_flatten_ = ConditionProfile.createBinaryProfile();
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.charCodeAtLazyString(arguments0Value_, arguments1Value_, this.charCodeAtLazyString_flatten_);
                            return object;
                        }
                        int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                        if (stringCast0 != 0) {
                            String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                            if (StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                                state |= stringCast0 << 4;
                                this.state_ = state |= 2;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.charCodeAtInBounds(arguments0Value_, arguments1Value_);
                                return n;
                            }
                            if (!StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                                state |= stringCast0 << 4;
                                this.state_ = state |= 4;
                                lock.unlock();
                                hasLock = false;
                                Double d = this.charCodeAtOutOfBounds(arguments0Value_, arguments1Value_);
                                return d;
                            }
                        }
                    }
                    this.charCodeAtGeneric_toNumberNode_ = (JSToNumberNode)super.insert((Node)JSToNumberNode.create());
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.charCodeAtGeneric(arguments0Value, arguments1Value, this.charCodeAtGeneric_toNumberNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 0xF & (state & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public Introspection getIntrospectionData() {
                ArrayList<List<Object>> cached;
                Object[] data = new Object[5];
                data[0] = 0;
                int state = this.state_;
                Object[] s = new Object[3];
                s[0] = "charCodeAtLazyString";
                if ((state & 1) != 0) {
                    s[1] = (byte)1;
                    cached = new ArrayList<List<Object>>();
                    cached.add(Arrays.asList(this.charCodeAtLazyString_flatten_));
                    s[2] = cached;
                } else {
                    s[1] = (byte)0;
                }
                data[1] = s;
                s = new Object[3];
                s[0] = "charCodeAtInBounds";
                s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[2] = s;
                s = new Object[3];
                s[0] = "charCodeAtOutOfBounds";
                s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[3] = s;
                s = new Object[3];
                s[0] = "charCodeAtGeneric";
                if ((state & 8) != 0) {
                    s[1] = (byte)1;
                    cached = new ArrayList();
                    cached.add(Arrays.asList(this.charCodeAtGeneric_toNumberNode_));
                    s[2] = cached;
                } else {
                    s[1] = (byte)0;
                }
                data[4] = s;
                return Introspection.Provider.create((Object[])data);
            }

            public static StringPrototypeBuiltins.JSStringCharCodeAtNode.Inlined create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                return new InlinedNodeGen(context, builtin, arguments);
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringCharAtNode.class)
    public static final class JSStringCharAtNodeGen
    extends StringPrototypeBuiltins.JSStringCharAtNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSStringCharAtNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && (state & 3) != 0) {
                return this.execute_int0(frameValue, state);
            }
            return this.execute_generic1(frameValue, state);
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            if (JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                return this.stringCharAt(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic1(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    return this.stringCharAt(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 2) != 0) {
                return this.charAt(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
            if (stringCast0 != 0) {
                String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                if (arguments1Value instanceof Integer) {
                    int arguments1Value_ = (Integer)arguments1Value;
                    state |= stringCast0 << 2;
                    this.state_ = state |= 1;
                    return this.stringCharAt(arguments0Value_, arguments1Value_);
                }
            }
            this.state_ = state |= 2;
            return this.charAt(arguments0Value, arguments1Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 3 & (state & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "stringCharAt";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "charAt";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static StringPrototypeBuiltins.JSStringCharAtNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringCharAtNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringCharAtNode.Inlined.class)
        public static final class InlinedNodeGen
        extends StringPrototypeBuiltins.JSStringCharAtNode.Inlined
        implements Introspection.Provider {
            @Node.Child
            private JavaScriptNode arguments0_;
            @Node.Child
            private JavaScriptNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private int state_;

            private InlinedNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                super(context, builtin);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public JavaScriptNode[] getArguments() {
                return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
            }

            @Override
            protected Object executeWithArguments(Object arguments0Value, Object arguments1Value) {
                int state = this.state_;
                if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value)) {
                    String arguments0Value_ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.stringCharAt(arguments0Value_, arguments1Value_);
                    }
                }
                if ((state & 2) != 0) {
                    return this.charAt(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state = this.state_;
                if ((state & 2) == 0 && (state & 3) != 0) {
                    return this.execute_int0(frameValue, state);
                }
                return this.execute_generic1(frameValue, state);
            }

            private Object execute_int0(VirtualFrame frameValue, int state) {
                int arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.executeAndSpecialize(arguments0Value_, ex.getResult());
                }
                assert ((state & 1) != 0);
                if (JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                    return this.stringCharAt(arguments0Value__, arguments1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object execute_generic1(VirtualFrame frameValue, int state) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments0Value_);
                    if (arguments1Value_ instanceof Integer) {
                        int arguments1Value__ = (Integer)arguments1Value_;
                        return this.stringCharAt(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 2) != 0) {
                    return this.charAt(arguments0Value_, arguments1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state = this.state_;
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        state |= stringCast0 << 2;
                        this.state_ = state |= 1;
                        return this.stringCharAt(arguments0Value_, arguments1Value_);
                    }
                }
                this.state_ = state |= 2;
                return this.charAt(arguments0Value, arguments1Value);
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 3 & (state & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public Introspection getIntrospectionData() {
                Object[] data = new Object[3];
                data[0] = 0;
                int state = this.state_;
                Object[] s = new Object[3];
                s[0] = "stringCharAt";
                s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[1] = s;
                s = new Object[3];
                s[0] = "charAt";
                s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[2] = s;
                return Introspection.Provider.create((Object[])data);
            }

            public static StringPrototypeBuiltins.JSStringCharAtNode.Inlined create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                return new InlinedNodeGen(context, builtin, arguments);
            }
        }
    }
}

