/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.wagon.git.internal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GitUri {
    private final String branchName;
    private final String gitRepositoryUri;
    private final String resource;

    public GitUri(String gitRepositoryUri, String branchName, String resource) {
        this.gitRepositoryUri = gitRepositoryUri;
        this.branchName = branchName;
        this.resource = resource;
    }

    private GitUri(URI gitUri) {
        this.branchName = gitUri.getQuery();
        String asciiUriString = gitUri.toASCIIString();
        this.gitRepositoryUri = asciiUriString.substring(0, asciiUriString.lastIndexOf(63));
        this.resource = gitUri.getFragment();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GitUri x = (GitUri)obj;
        return new EqualsBuilder().append((Object)this.branchName, (Object)x.branchName).append((Object)this.gitRepositoryUri, (Object)x.gitRepositoryUri).append((Object)this.resource, (Object)x.resource).build();
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getGitRepositoryUri() {
        return this.gitRepositoryUri;
    }

    public String getResource() {
        return this.resource;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.resource).append((Object)this.branchName).append((Object)this.gitRepositoryUri).build();
    }

    public GitUri resolve(String fragment) {
        String decodedFragment;
        try {
            decodedFragment = URLDecoder.decode(fragment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        URI combined = this.resource != null ? URI.create(this.gitRepositoryUri + this.resource.replace("##", "#")) : URI.create(this.gitRepositoryUri);
        String slashAppendedUri = combined.toASCIIString();
        URI resolvedUri = URI.create(slashAppendedUri).resolve(decodedFragment.replace(" ", "%2520"));
        StringBuilder resolved = new StringBuilder(resolvedUri.toASCIIString());
        int lastQuestionMark = resolved.lastIndexOf("?");
        if (lastQuestionMark == -1) {
            return new GitUri(URI.create(String.format("%s?%s#%s", this.gitRepositoryUri, this.branchName, decodedFragment.replace(" ", "%20"))));
        }
        int lastRelevantSlash = resolved.indexOf("/", lastQuestionMark);
        int lastRelevantHash = resolved.indexOf("#", lastQuestionMark);
        if (lastRelevantSlash > 0 && lastRelevantHash >= lastRelevantSlash) {
            resolved.insert(lastRelevantSlash, '#');
        }
        return new GitUri(URI.create(resolved.toString()));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.gitRepositoryUri).append((Object)this.branchName).append((Object)this.resource).build();
    }
}

