/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.logging.Logger;

public class Point
implements SQLData {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private double m_x;
    private double m_y;
    private String m_typeName;

    @Override
    public String getSQLTypeName() {
        return this.m_typeName;
    }

    @Override
    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        s_logger.info(string + " from SQLInput");
        this.m_x = sQLInput.readDouble();
        this.m_y = sQLInput.readDouble();
        this.m_typeName = string;
    }

    @Override
    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        s_logger.info(this.m_typeName + " to SQLOutput");
        sQLOutput.writeDouble(this.m_x);
        sQLOutput.writeDouble(this.m_y);
    }

    public static Point logAndReturn(Point point) {
        s_logger.info(point.getSQLTypeName() + point);
        return point;
    }
}

