/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.logging.Logger;

public class Parameters {
    static void log(String string) {
        if ("GNU libgcj".equals(System.getProperty("java.vm.name"))) {
            System.out.print("INFO: ");
            System.out.println(string);
        } else {
            Logger.getAnonymousLogger().info(string);
        }
    }

    public static int addOne(int n) {
        return n + 1;
    }

    public static int addOne(Integer n) {
        return n + 1;
    }

    public static Integer nullOnEven(int n) {
        return n % 2 == 0 ? null : new Integer(n);
    }

    public static int addOneLong(long l) {
        return (int)l + 1;
    }

    public static double addNumbers(short s, int n, long l, BigDecimal bigDecimal, BigDecimal bigDecimal2, float f, double d) {
        return bigDecimal.doubleValue() + bigDecimal2.doubleValue() + (double)s + (double)n + (double)l + (double)f + d;
    }

    public static Date getDate() {
        return new Date(System.currentTimeMillis());
    }

    public static Time getTime() {
        return new Time(System.currentTimeMillis());
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static int countNulls(ResultSet resultSet) throws SQLException {
        int n = 0;
        int n2 = resultSet.getMetaData().getColumnCount();
        for (int i = 1; i <= n2; ++i) {
            resultSet.getObject(i);
            if (!resultSet.wasNull()) continue;
            ++n;
        }
        return n;
    }

    public static int countNulls(Integer[] integerArray) throws SQLException {
        int n = 0;
        int n2 = integerArray.length;
        for (int i = 0; i < n2; ++i) {
            if (integerArray[i] != null) continue;
            ++n;
        }
        return n;
    }

    public static byte print(byte by) {
        Parameters.log("byte " + by);
        return by;
    }

    public static byte[] print(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        stringBuffer.append("byte[] of size " + n);
        if (n > 0) {
            stringBuffer.append(" {");
            stringBuffer.append(byArray[0]);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(byArray[i]);
            }
            stringBuffer.append('}');
        }
        Parameters.log(stringBuffer.toString());
        return byArray;
    }

    public static short print(short s) {
        Parameters.log("short " + s);
        return s;
    }

    public static short[] print(short[] sArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = sArray.length;
        stringBuffer.append("short[] of size " + n);
        if (n > 0) {
            stringBuffer.append(" {");
            stringBuffer.append(sArray[0]);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(sArray[i]);
            }
            stringBuffer.append('}');
        }
        Parameters.log(stringBuffer.toString());
        return sArray;
    }

    public static int print(int n) {
        Parameters.log("int " + n);
        return n;
    }

    public static int[] print(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        stringBuffer.append("int[] of size " + n);
        if (n > 0) {
            stringBuffer.append(" {");
            stringBuffer.append(nArray[0]);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(nArray[i]);
            }
            stringBuffer.append('}');
        }
        Parameters.log(stringBuffer.toString());
        return nArray;
    }

    public static long print(long l) {
        Parameters.log("long " + l);
        return l;
    }

    public static long[] print(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = lArray.length;
        stringBuffer.append("long[] of size " + n);
        if (n > 0) {
            stringBuffer.append(" {");
            stringBuffer.append(lArray[0]);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(lArray[i]);
            }
            stringBuffer.append('}');
        }
        Parameters.log(stringBuffer.toString());
        return lArray;
    }

    public static float print(float f) {
        Parameters.log("float " + f);
        return f;
    }

    public static float[] print(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = fArray.length;
        stringBuffer.append("float[] of size " + n);
        if (n > 0) {
            stringBuffer.append(" {");
            stringBuffer.append(fArray[0]);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(fArray[i]);
            }
            stringBuffer.append('}');
        }
        Parameters.log(stringBuffer.toString());
        return fArray;
    }

    public static double print(double d) {
        Parameters.log("double " + d);
        return d;
    }

    public static double[] print(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = dArray.length;
        stringBuffer.append("double[] of size " + n);
        if (n > 0) {
            stringBuffer.append(" {");
            stringBuffer.append(dArray[0]);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(dArray[i]);
            }
            stringBuffer.append('}');
        }
        Parameters.log(stringBuffer.toString());
        return dArray;
    }

    public static Integer[] print(Integer[] integerArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = integerArray.length;
        stringBuffer.append("Integer[] of size " + n);
        if (n > 0) {
            stringBuffer.append(" {");
            stringBuffer.append(integerArray[0]);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(integerArray[i]);
            }
            stringBuffer.append('}');
        }
        Parameters.log(stringBuffer.toString());
        return integerArray;
    }

    public static void print(Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance(0);
        Parameters.log("Local Date is " + dateFormat.format(date));
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Parameters.log("UTC Date is " + dateFormat.format(date));
        Parameters.log("TZ =  " + TimeZone.getDefault().getDisplayName());
    }

    public static void print(Time time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss z Z");
        Parameters.log("Local Time is " + simpleDateFormat.format(time));
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Parameters.log("UTC Time is " + simpleDateFormat.format(time));
        Parameters.log("TZ =  " + TimeZone.getDefault().getDisplayName());
    }

    public static void print(Timestamp timestamp) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        Parameters.log("Local Timestamp is " + dateFormat.format(timestamp));
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Parameters.log("UTC Timestamp is " + dateFormat.format(timestamp));
        Parameters.log("TZ =  " + TimeZone.getDefault().getDisplayName());
    }
}

