/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.AbstractResultSetMetaData;
import org.postgresql.pljava.jdbc.ResultSetField;

public class SyntheticResultSetMetaData
extends AbstractResultSetMetaData {
    private final ResultSetField[] m_fields;

    public SyntheticResultSetMetaData(ResultSetField[] resultSetFieldArray) {
        this.m_fields = resultSetFieldArray;
    }

    @Override
    public final int getColumnCount() throws SQLException {
        return this.m_fields.length;
    }

    @Override
    public final boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    @Override
    public final String getColumnLabel(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.m_fields[n - 1].getColumnLabel();
    }

    @Override
    public final String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.m_fields[n - 1].getJavaClass().getName();
    }

    @Override
    protected final void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.m_fields.length) {
            throw new SQLException("Invalid column index: " + n);
        }
    }

    @Override
    protected final Oid getOid(int n) throws SQLException {
        return this.m_fields[n - 1].getOID();
    }

    @Override
    protected final int getFieldLength(int n) throws SQLException {
        return this.m_fields[n - 1].getLength();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isWrapperFor( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".unwrapClass( Class<?> ) not implemented yet.", "0A000");
    }
}

