/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.PgSavepoint;
import org.postgresql.pljava.jdbc.Invocation;
import org.postgresql.pljava.jdbc.SPIDatabaseMetaData;
import org.postgresql.pljava.jdbc.SPIPreparedStatement;
import org.postgresql.pljava.jdbc.SPIStatement;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIConnection
implements Connection {
    private static final HashMap s_sqlType2Class = new HashMap(30);
    private int[] VERSION_NUMBER = null;
    private Properties _clientInfo;
    public static final String[] JDBC3_TYPE_NAMES;
    public static final int[] JDBC_TYPE_NUMBERS;

    private static final void addType(Class clazz, int n) {
        s_sqlType2Class.put(clazz, new Integer(n));
    }

    public static Connection getDefault() throws SQLException {
        return new SPIConnection();
    }

    @Override
    public int getHoldability() {
        return 2;
    }

    @Override
    public int getTransactionIsolation() {
        return 2;
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedFeatureException("Connection.clearWarnings");
    }

    @Override
    public void close() {
    }

    @Override
    public void commit() throws SQLException {
        throw new UnsupportedFeatureException("Connection.commit");
    }

    @Override
    public void rollback() throws SQLException {
        throw new UnsupportedFeatureException("Connection.rollback");
    }

    @Override
    public boolean getAutoCommit() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setHoldability");
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setTransactionIsolation");
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setAutoCommit");
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setReadOnly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        ResultSet resultSet = this.createStatement().executeQuery("SELECT pg_catalog.current_database()");
        try {
            resultSet.next();
            String string = resultSet.getString(1);
            return string;
        }
        finally {
            resultSet.close();
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        throw new UnsupportedFeatureException("Connection.setCatalog");
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new SPIDatabaseMetaData(this);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedFeatureException("Connection.getWarnings");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof PgSavepoint)) {
            throw new IllegalArgumentException("Not a PL/Java Savepoint");
        }
        PgSavepoint pgSavepoint = (PgSavepoint)savepoint;
        pgSavepoint.release();
        SPIConnection.forgetSavepoint(pgSavepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof PgSavepoint)) {
            throw new IllegalArgumentException("Not a PL/Java Savepoint");
        }
        PgSavepoint pgSavepoint = (PgSavepoint)savepoint;
        Invocation.clearErrorCondition();
        pgSavepoint.rollback();
        SPIConnection.forgetSavepoint(pgSavepoint);
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return new SPIStatement(this);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        if (n != 1003) {
            throw new UnsupportedOperationException("TYPE_FORWARD_ONLY supported ResultSet type");
        }
        if (n2 != 1007) {
            throw new UnsupportedOperationException("CONCUR_READ_ONLY is the supported ResultSet concurrency");
        }
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 != 2) {
            throw new UnsupportedOperationException("CLOSE_CURSORS_AT_COMMIT is the only supported ResultSet holdability");
        }
        return this.createStatement(n, n2);
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException("Type map is not yet implemented");
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return this.nativeSQL(string, null);
    }

    public String nativeSQL(String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        int n3 = 1;
        block5: for (int i = 0; i < n; ++i) {
            int n4 = string.charAt(i);
            switch (n4) {
                case 92: {
                    stringBuffer.append((char)n4);
                    if (++i == n) break;
                    n4 = string.charAt(i);
                    break;
                }
                case 34: 
                case 39: {
                    if (n2 == n4) {
                        n2 = 0;
                        break;
                    }
                    n2 = n4;
                    break;
                }
                case 63: {
                    if (n2 != 0) break;
                    stringBuffer.append('$');
                    stringBuffer.append(n3++);
                    continue block5;
                }
                default: {
                    if (n2 != 0 || !Character.isWhitespace((char)n4)) break;
                    ++i;
                    while (i < n && Character.isWhitespace(string.charAt(i))) {
                        ++i;
                    }
                    --i;
                    n4 = 32;
                }
            }
            stringBuffer.append((char)n4);
        }
        if (nArray != null) {
            nArray[0] = n3 - 1;
        }
        return stringBuffer.toString();
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException("Procedure calls are not yet implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        int[] nArray = new int[]{0};
        string = this.nativeSQL(string, nArray);
        SPIPreparedStatement sPIPreparedStatement = new SPIPreparedStatement(this, string, nArray[0]);
        Invocation.current().manageStatement(sPIPreparedStatement);
        return sPIPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (n != 1003) {
            throw new UnsupportedOperationException("TYPE_FORWARD_ONLY supported ResultSet type");
        }
        if (n2 != 1007) {
            throw new UnsupportedOperationException("CONCUR_READ_ONLY is the supported ResultSet concurrency");
        }
        return this.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 != 2) {
            throw new UnsupportedOperationException("CLOSE_CURSORS_AT_COMMIT is the only supported ResultSet holdability");
        }
        return this.prepareStatement(string, n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.rememberSavepoint(PgSavepoint.set("anonymous_savepoint"));
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return this.rememberSavepoint(PgSavepoint.set(string));
    }

    static int getTypeForClass(Class clazz) {
        if (clazz.isArray() && !clazz.equals(byte[].class)) {
            return 2003;
        }
        Integer n = (Integer)s_sqlType2Class.get(clazz);
        if (n != null) {
            return n;
        }
        return 1111;
    }

    private Savepoint rememberSavepoint(PgSavepoint pgSavepoint) throws SQLException {
        Invocation invocation = Invocation.current();
        PgSavepoint pgSavepoint2 = invocation.getSavepoint();
        if (pgSavepoint2 == null) {
            invocation.setSavepoint(pgSavepoint);
        }
        return pgSavepoint;
    }

    private static void forgetSavepoint(PgSavepoint pgSavepoint) throws SQLException {
        Invocation invocation = Invocation.current();
        if (invocation.getSavepoint() == pgSavepoint) {
            invocation.setSavepoint(null);
        }
    }

    public int[] getVersionNumber() throws SQLException {
        if (this.VERSION_NUMBER != null) {
            return this.VERSION_NUMBER;
        }
        ResultSet resultSet = this.createStatement().executeQuery("SELECT version()");
        try {
            if (!resultSet.next()) {
                throw new SQLException("Cannot retrieve product version number");
            }
            String string = resultSet.getString(1);
            Pattern pattern = Pattern.compile("^PostgreSQL\\s+(\\d+)\\.(\\d+)(.\\d+)?.*");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                this.VERSION_NUMBER = new int[3];
                this.VERSION_NUMBER[0] = Integer.parseInt(matcher.group(1));
                this.VERSION_NUMBER[1] = Integer.parseInt(matcher.group(2));
                String string2 = matcher.group(3);
                if (string2 != null && string2.length() > 1) {
                    this.VERSION_NUMBER[2] = Integer.parseInt(string2.substring(1));
                }
                int[] nArray = this.VERSION_NUMBER;
                return nArray;
            }
            try {
                throw new SQLException("Unexpected product version string format: " + string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SQLException("Error in product version string parsing: " + patternSyntaxException.getMessage());
            }
        }
        finally {
            resultSet.close();
        }
    }

    public int getSQLType(String string) {
        if (string == null) {
            return 1111;
        }
        for (int i = 0; i < JDBC3_TYPE_NAMES.length; ++i) {
            if (!string.equals(JDBC3_TYPE_NAMES[i])) continue;
            return JDBC_TYPE_NUMBERS[i];
        }
        return 1111;
    }

    public int getSQLType(Oid oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPGType(Oid oid) throws SQLException {
        String string;
        block5: {
            string = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement("SELECT typname FROM pg_catalog.pg_type WHERE oid=?");
                preparedStatement.setObject(1, oid);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                    break block5;
                }
                throw new SQLException("Cannot find PG type with oid=" + oid);
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        return string;
    }

    static Object basicCoersion(Class clazz, Object object) throws SQLException {
        if (object == null || clazz.isInstance(object)) {
            return object;
        }
        if (clazz == String.class) {
            if (object instanceof Number || object instanceof Boolean || object instanceof Timestamp || object instanceof Date || object instanceof Time) {
                return object.toString();
            }
        } else if (clazz == URL.class && object instanceof String) {
            try {
                return new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SQLException(malformedURLException.toString());
            }
        }
        throw new SQLException("Cannot derive a value of class " + clazz.getName() + " from an object of class " + object.getClass().getName());
    }

    static Number basicNumericCoersion(Class clazz, Object object) throws SQLException {
        if (object == null || object instanceof Number) {
            return (Number)object;
        }
        if (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
            if (object instanceof String) {
                return Long.valueOf((String)object);
            }
            if (object instanceof Boolean) {
                return new Long((Boolean)object != false ? 1L : 0L);
            }
        } else if (clazz == BigDecimal.class) {
            if (object instanceof String) {
                return new BigDecimal((String)object);
            }
            if (object instanceof Boolean) {
                return new BigDecimal((Boolean)object != false ? 1 : 0);
            }
        }
        if (clazz == Double.TYPE || clazz == Float.TYPE) {
            if (object instanceof String) {
                return Double.valueOf((String)object);
            }
            if (object instanceof Boolean) {
                return new Double((Boolean)object != false ? 1.0 : 0.0);
            }
        }
        throw new SQLException("Cannot derive a Number from an object of class " + object.getClass().getName());
    }

    static Object basicCalendricalCoersion(Class clazz, Object object, Calendar calendar) throws SQLException {
        if (object == null) {
            return object;
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        if (clazz == Timestamp.class) {
            if (object instanceof Date) {
                calendar.setTime((Date)object);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (object instanceof Time) {
                calendar.setTime((Date)object);
                calendar.set(1970, 0, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (object instanceof String) {
                return Timestamp.valueOf((String)object);
            }
        } else if (clazz == Date.class) {
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                calendar.setTime(timestamp);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return new Date(calendar.getTimeInMillis());
            }
            if (object instanceof String) {
                return Date.valueOf((String)object);
            }
        } else if (clazz == Time.class) {
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                calendar.setTime(timestamp);
                calendar.set(1970, 0, 1);
                return new Time(calendar.getTimeInMillis());
            }
            if (object instanceof String) {
                return Time.valueOf((String)object);
            }
        }
        throw new SQLException("Cannot derive a value of class " + clazz.getName() + " from an object of class " + object.getClass().getName());
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIConnection.createStruct( String, Object[] ) not implemented yet.", "0A000");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIConnection.createArrayOf( String, Object[] ) not implemented yet.", "0A000");
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return true;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIConnection.createSQLXML() not implemented yet.", "0A000");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIConnection.createNClob() not implemented yet.", "0A000");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIConnection.createBlob() not implemented yet.", "0A000");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("SPIConnection.createClob() not implemented yet.", "0A000");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isWrapperFor( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".unwrapClass( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        throw new SQLClientInfoException("ClientInfo property not supported.", hashMap);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        Iterator<String> iterator = properties.stringPropertyNames().iterator();
        while (iterator.hasNext()) {
            hashMap.put(iterator.next(), ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        throw new SQLClientInfoException("ClientInfo property not supported.", hashMap);
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this._clientInfo == null) {
            this._clientInfo = new Properties();
        }
        return this._clientInfo;
    }

    static {
        SPIConnection.addType(String.class, 12);
        SPIConnection.addType(Byte.class, -6);
        SPIConnection.addType(Short.class, 5);
        SPIConnection.addType(Integer.class, 4);
        SPIConnection.addType(Long.class, -5);
        SPIConnection.addType(Float.class, 6);
        SPIConnection.addType(Double.class, 8);
        SPIConnection.addType(BigDecimal.class, 3);
        SPIConnection.addType(BigInteger.class, 2);
        SPIConnection.addType(Boolean.class, 16);
        SPIConnection.addType(Blob.class, 2004);
        SPIConnection.addType(Clob.class, 2005);
        SPIConnection.addType(Date.class, 91);
        SPIConnection.addType(Time.class, 92);
        SPIConnection.addType(Timestamp.class, 93);
        SPIConnection.addType(java.util.Date.class, 93);
        SPIConnection.addType(byte[].class, -3);
        SPIConnection.addType(BitSet.class, -7);
        SPIConnection.addType(URL.class, 70);
        JDBC3_TYPE_NAMES = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "bit", "date", "time", "timetz", "abstime", "timestamp", "timestamptz", "_bool", "_char", "_int2", "_int4", "_text", "_oid", "_varchar", "_int8", "_float4", "_float8", "_abstime", "_date", "_time", "_timestamp", "_numeric", "_bytea"};
        JDBC_TYPE_NUMBERS = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, 16, -7, 91, 92, 92, 93, 93, 93, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003};
    }
}

