/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.postgresql.pljava.jdbc.AbstractResultSet;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public abstract class ObjectResultSet
extends AbstractResultSet {
    private boolean m_wasNull = false;

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return (Array)this.getValue(n, Array.class);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        Clob clob = this.getClob(n);
        return clob == null ? null : clob.getAsciiStream();
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getValue(n, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new UnsupportedFeatureException("getBigDecimal(int, int)");
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        Blob blob = this.getBlob(n);
        return blob == null ? null : blob.getBinaryStream();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : new BlobValue(byArray);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Boolean bl = (Boolean)this.getValue(n, Boolean.class);
        return bl == null ? false : bl;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Number number = this.getNumber(n, Byte.TYPE);
        return number == null ? (byte)0 : number.byteValue();
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.getValue(n, byte[].class);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        Clob clob = this.getClob(n);
        return clob == null ? null : clob.getCharacterStream();
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        String string = this.getString(n);
        return string == null ? null : new ClobValue(string);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return (Date)this.getValue(n, Date.class);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return (Date)this.getValue(n, Date.class, calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Number number = this.getNumber(n, Double.TYPE);
        return number == null ? 0.0 : number.doubleValue();
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Number number = this.getNumber(n, Float.TYPE);
        return number == null ? 0.0f : number.floatValue();
    }

    @Override
    public int getInt(int n) throws SQLException {
        Number number = this.getNumber(n, Integer.TYPE);
        return number == null ? 0 : number.intValue();
    }

    @Override
    public long getLong(int n) throws SQLException {
        Number number = this.getNumber(n, Long.TYPE);
        return number == null ? 0L : number.longValue();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedFeatureException("ResultSet meta data is not yet implemented");
    }

    @Override
    public final Object getObject(int n) throws SQLException {
        Object object = this.getObjectValue(n);
        this.m_wasNull = object == null;
        return object;
    }

    public final Object getObject(int n, Map map) throws SQLException {
        Object object = this.getObjectValue(n, map);
        this.m_wasNull = object == null;
        return object;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        return (Ref)this.getValue(n, Ref.class);
    }

    @Override
    public short getShort(int n) throws SQLException {
        Number number = this.getNumber(n, Short.TYPE);
        return number == null ? (short)0 : number.shortValue();
    }

    @Override
    public String getString(int n) throws SQLException {
        return (String)this.getValue(n, String.class);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return (Time)this.getValue(n, Time.class);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return (Time)this.getValue(n, Time.class, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getValue(n, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return (Timestamp)this.getValue(n, Timestamp.class, calendar);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new UnsupportedFeatureException("ResultSet.getUnicodeStream");
    }

    @Override
    public URL getURL(int n) throws SQLException {
        return (URL)this.getValue(n, URL.class);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedFeatureException("Refresh row");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.updateObject(n, (Object)array);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.updateObject(n, (Object)new ClobValue(new InputStreamReader(inputStream, "US-ASCII"), n2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("US-ASCII encoding is not supported by this JVM");
        }
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBlob(n, (Blob)new BlobValue(inputStream, n2));
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateObject(n, (Object)blob);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateClob(n, (Clob)new ClobValue(reader, n2));
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateObject(n, (Object)clob);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateObject(n, (Object)ref);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    @Override
    public boolean wasNull() {
        return this.m_wasNull;
    }

    protected final Number getNumber(int n, Class clazz) throws SQLException {
        Object object = this.getObjectValue(n);
        this.m_wasNull = object == null;
        return SPIConnection.basicNumericCoersion(clazz, object);
    }

    protected final Object getValue(int n, Class clazz) throws SQLException {
        return SPIConnection.basicCoersion(clazz, this.getObject(n));
    }

    protected Object getValue(int n, Class clazz, Calendar calendar) throws SQLException {
        return SPIConnection.basicCalendricalCoersion(clazz, this.getObject(n), calendar);
    }

    protected Object getObjectValue(int n, Map map) throws SQLException {
        if (map == null) {
            return this.getObjectValue(n);
        }
        throw new UnsupportedFeatureException("Obtaining values using explicit Map");
    }

    protected abstract Object getObjectValue(int var1) throws SQLException;
}

