/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.JavaWrapper;
import org.postgresql.pljava.internal.Relation;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.jdbc.TriggerResultSet;

public class TriggerData
extends JavaWrapper
implements org.postgresql.pljava.TriggerData {
    private Relation m_relation;
    private TriggerResultSet m_old = null;
    private TriggerResultSet m_new = null;
    private Tuple m_newTuple;
    private Tuple m_triggerTuple;

    TriggerData(long l) {
        super(l);
    }

    @Override
    public ResultSet getNew() throws SQLException {
        if (this.m_new != null) {
            return this.m_new;
        }
        if (this.isFiredByDelete() || this.isFiredForStatement()) {
            return null;
        }
        Tuple tuple = this.isFiredByInsert() ? this.getTriggerTuple() : this.getNewTuple();
        this.m_new = new TriggerResultSet(this.getRelation().getTupleDesc(), tuple, this.isFiredAfter());
        return this.m_new;
    }

    @Override
    public ResultSet getOld() throws SQLException {
        if (this.m_old != null) {
            return this.m_old;
        }
        if (this.isFiredByInsert() || this.isFiredForStatement()) {
            return null;
        }
        this.m_old = new TriggerResultSet(this.getRelation().getTupleDesc(), this.getTriggerTuple(), true);
        return this.m_old;
    }

    public long getTriggerReturnTuple() throws SQLException {
        Object[] objectArray;
        if (this.isFiredForStatement() || this.isFiredAfter()) {
            return 0L;
        }
        if (this.m_new != null && (objectArray = this.m_new.getChangeIndexesAndValues()) != null) {
            Tuple tuple = (Tuple)objectArray[0];
            int[] nArray = (int[])objectArray[1];
            Object[] objectArray2 = (Object[])objectArray[2];
            return this.getRelation().modifyTuple(tuple, nArray, objectArray2).getNativePointer();
        }
        return (this.isFiredByUpdate() ? this.getNewTuple() : this.getTriggerTuple()).getNativePointer();
    }

    @Override
    public String getTableName() throws SQLException {
        return this.getRelation().getName();
    }

    @Override
    public String getSchemaName() throws SQLException {
        return this.getRelation().getSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relation getRelation() throws SQLException {
        if (this.m_relation == null) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                this.m_relation = TriggerData._getRelation(this.getNativePointer());
            }
        }
        return this.m_relation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple getTriggerTuple() throws SQLException {
        if (this.m_triggerTuple == null) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                this.m_triggerTuple = TriggerData._getTriggerTuple(this.getNativePointer());
            }
        }
        return this.m_triggerTuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple getNewTuple() throws SQLException {
        if (this.m_newTuple == null) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                this.m_newTuple = TriggerData._getNewTuple(this.getNativePointer());
            }
        }
        return this.m_newTuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getArguments() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._getArguments(this.getNativePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._getName(this.getNativePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFiredAfter() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._isFiredAfter(this.getNativePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFiredBefore() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._isFiredBefore(this.getNativePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFiredForEachRow() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._isFiredForEachRow(this.getNativePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFiredForStatement() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._isFiredForStatement(this.getNativePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFiredByDelete() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._isFiredByDelete(this.getNativePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFiredByInsert() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._isFiredByInsert(this.getNativePointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFiredByUpdate() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TriggerData._isFiredByUpdate(this.getNativePointer());
        }
    }

    @Override
    protected native void _free(long var1);

    private static native Relation _getRelation(long var0) throws SQLException;

    private static native Tuple _getTriggerTuple(long var0) throws SQLException;

    private static native Tuple _getNewTuple(long var0) throws SQLException;

    private static native String[] _getArguments(long var0) throws SQLException;

    private static native String _getName(long var0) throws SQLException;

    private static native boolean _isFiredAfter(long var0) throws SQLException;

    private static native boolean _isFiredBefore(long var0) throws SQLException;

    private static native boolean _isFiredForEachRow(long var0) throws SQLException;

    private static native boolean _isFiredForStatement(long var0) throws SQLException;

    private static native boolean _isFiredByDelete(long var0) throws SQLException;

    private static native boolean _isFiredByInsert(long var0) throws SQLException;

    private static native boolean _isFiredByUpdate(long var0) throws SQLException;
}

