/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.deploy;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class Deployer {
    private static final int CMD_AMBIGUOUS = -2;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_UNINSTALL = 0;
    private static final int CMD_INSTALL = 1;
    private static final int CMD_REINSTALL = 2;
    private static final int CMD_USER = 3;
    private static final int CMD_PASSWORD = 4;
    private static final int CMD_DATABASE = 5;
    private static final int CMD_HOSTNAME = 6;
    private static final int CMD_PORT = 7;
    private final Connection m_connection;
    private static final ArrayList s_commands = new ArrayList();

    private static final int getCommand(String string) {
        int n = s_commands.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!((String)s_commands.get(i)).startsWith(string)) continue;
            if (n2 != -1) {
                return -2;
            }
            n2 = i;
        }
        return n2;
    }

    public static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("usage: java org.postgresql.pljava.deploy.Deployer");
        printStream.println("    {-install | -uninstall | -reinstall}");
        printStream.println("    [ -host <hostName>     ]    # default is localhost");
        printStream.println("    [ -port <portNumber>   ]    # default is blank");
        printStream.println("    [ -database <database> ]    # default is name of current user");
        printStream.println("    [ -user <userName>     ]    # default is name of current user");
        printStream.println("    [ -password <password> ]    # default is no password");
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        String string2 = "org.postgresql.Driver";
        String string3 = "localhost";
        String string4 = string = System.getProperty("user.name", "postgres");
        String string5 = "postgresql";
        String string6 = null;
        String string7 = null;
        int n = -1;
        int n2 = stringArray.length;
        block10: for (int i = 0; i < n2; ++i) {
            object = stringArray[i];
            if (((String)object).length() < 2) {
                Deployer.printUsage();
                return;
            }
            if (((String)object).charAt(0) != '-') continue;
            int n3 = Deployer.getCommand(((String)object).substring(1));
            switch (n3) {
                case 0: 
                case 1: 
                case 2: {
                    if (n != -1) {
                        Deployer.printUsage();
                        return;
                    }
                    n = n3;
                    continue block10;
                }
                case 3: {
                    if (++i < n2 && (string = stringArray[i]).length() > 0 && string.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                case 4: {
                    if (++i < n2 && (string6 = stringArray[i]).length() > 0 && string6.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                case 5: {
                    if (++i < n2 && (string4 = stringArray[i]).length() > 0 && string4.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                case 6: {
                    if (++i < n2 && (string3 = stringArray[i]).length() > 0 && string3.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                case 7: {
                    if (++i < n2 && (string7 = stringArray[i]).length() > 0 && string7.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                default: {
                    Deployer.printUsage();
                    return;
                }
            }
        }
        if (n == -1) {
            Deployer.printUsage();
            return;
        }
        try {
            Class.forName(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("jdbc:");
            stringBuffer.append(string5);
            stringBuffer.append("://");
            stringBuffer.append(string3);
            if (string7 != null) {
                stringBuffer.append(':');
                stringBuffer.append(string7);
            }
            stringBuffer.append('/');
            stringBuffer.append(string4);
            object = DriverManager.getConnection(stringBuffer.toString(), string, string6);
            Deployer.checkIfConnectedAsSuperuser((Connection)object);
            object.setAutoCommit(false);
            Deployer deployer = new Deployer((Connection)object);
            if (n == 0 || n == 2) {
                deployer.dropSQLJSchema();
            }
            if (n == 1 || n == 2) {
                deployer.createSQLJSchema();
                deployer.initJavaHandlers();
                deployer.initializeSQLJSchema();
            }
            object.commit();
            object.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Deployer(Connection connection) {
        this.m_connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIfConnectedAsSuperuser(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SHOW IS_SUPERUSER");
        try {
            if (resultSet.next() && resultSet.getString(1).equals("on")) {
                return;
            }
        }
        finally {
            resultSet.close();
            statement.close();
        }
        throw new SQLException("You must be a superuser to deploy/undeploy pl/Java.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void dropSQLJSchema() throws SQLException {
        var1_1 = this.m_connection.createStatement();
        var2_2 = null;
        try {
            if (this.m_connection.getMetaData().supportsSavepoints()) {
                var2_2 = this.m_connection.setSavepoint();
            }
            var1_1.execute("DROP LANGUAGE java CASCADE");
            var1_1.execute("DROP LANGUAGE javaU CASCADE");
            ** if (var2_2 == null) goto lbl-1000
        }
        catch (SQLException var3_3) {
            try {
                if (var2_2 != null) {
                    this.m_connection.rollback(var2_2);
                } else {
                    this.m_connection.rollback();
                }
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var4_4) {
                if (var2_2 != null) {
                    this.m_connection.releaseSavepoint(var2_2);
                }
                throw var4_4;
            }
lbl-1000:
            // 1 sources

            {
                this.m_connection.releaseSavepoint(var2_2);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.m_connection.releaseSavepoint(var2_2);
        }
lbl-1000:
        // 2 sources

        {
        }
        var1_1.execute("DROP SCHEMA sqlj CASCADE");
        var1_1.close();
    }

    public void createSQLJSchema() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("CREATE SCHEMA sqlj");
        statement.execute("GRANT USAGE ON SCHEMA sqlj TO public");
        statement.close();
    }

    public void initializeSQLJSchema() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("CREATE TABLE sqlj.jar_repository(\tjarId\t\tSERIAL PRIMARY KEY,\tjarName\t\tVARCHAR(100) UNIQUE NOT NULL,\tjarOrigin   VARCHAR(500) NOT NULL,\tjarOwner\tNAME NOT NULL,\tjarManifest\tTEXT,   deploymentDesc INT)");
        statement.execute("GRANT SELECT ON sqlj.jar_repository TO public");
        statement.execute("CREATE TABLE sqlj.jar_entry(   entryId     SERIAL PRIMARY KEY,\tentryName\tVARCHAR(200) NOT NULL,\tjarId\t\tINT NOT NULL REFERENCES sqlj.jar_repository ON DELETE CASCADE,   entryImage  BYTEA NOT NULL,   UNIQUE(jarId, entryName))");
        statement.execute("GRANT SELECT ON sqlj.jar_entry TO public");
        statement.execute("ALTER TABLE sqlj.jar_repository   ADD FOREIGN KEY (deploymentDesc) REFERENCES sqlj.jar_entry ON DELETE SET NULL");
        statement.execute("CREATE TABLE sqlj.classpath_entry(\tschemaName\tVARCHAR(30) NOT NULL,\tordinal\t\tINT2 NOT NULL,\tjarId\t\tINT NOT NULL REFERENCES sqlj.jar_repository ON DELETE CASCADE,\tPRIMARY KEY(schemaName, ordinal))");
        statement.execute("GRANT SELECT ON sqlj.classpath_entry TO public");
        statement.execute("CREATE TABLE sqlj.typemap_entry(\tmapId\t\tSERIAL PRIMARY KEY,\tjavaName\tVARCHAR(200) NOT NULL,\tsqlName\t\tNAME NOT NULL)");
        statement.execute("GRANT SELECT ON sqlj.typemap_entry TO public");
        statement.execute("CREATE FUNCTION sqlj.install_jar(VARCHAR, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.installJar'\tLANGUAGE java SECURITY DEFINER");
        statement.execute("CREATE FUNCTION sqlj.replace_jar(VARCHAR, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.replaceJar'\tLANGUAGE java SECURITY DEFINER");
        statement.execute("CREATE FUNCTION sqlj.remove_jar(VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.removeJar'\tLANGUAGE java SECURITY DEFINER");
        statement.execute("CREATE FUNCTION sqlj.install_jar(BYTEA, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.installJar'\tLANGUAGE java SECURITY DEFINER");
        statement.execute("CREATE FUNCTION sqlj.replace_jar(BYTEA, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.replaceJar'\tLANGUAGE java SECURITY DEFINER");
        statement.execute("CREATE FUNCTION sqlj.set_classpath(VARCHAR, VARCHAR) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.setClassPath'\tLANGUAGE java SECURITY DEFINER");
        statement.execute("CREATE FUNCTION sqlj.get_classpath(VARCHAR) RETURNS VARCHAR\tAS 'org.postgresql.pljava.management.Commands.getClassPath'\tLANGUAGE java STABLE SECURITY DEFINER");
        statement.execute("CREATE FUNCTION sqlj.add_type_mapping(VARCHAR, VARCHAR) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.addTypeMapping'\tLANGUAGE java SECURITY DEFINER");
        statement.execute("CREATE FUNCTION sqlj.drop_type_mapping(VARCHAR) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.dropTypeMapping'\tLANGUAGE java SECURITY DEFINER");
        statement.close();
    }

    public void initJavaHandlers() throws SQLException {
        Statement statement = this.m_connection.createStatement();
        statement.execute("CREATE FUNCTION sqlj.java_call_handler() RETURNS language_handler AS 'pljava' LANGUAGE C");
        statement.execute("CREATE TRUSTED LANGUAGE java HANDLER sqlj.java_call_handler");
        statement.execute("CREATE FUNCTION sqlj.javau_call_handler() RETURNS language_handler AS 'pljava' LANGUAGE C");
        statement.execute("CREATE LANGUAGE javaU HANDLER sqlj.javau_call_handler");
        statement.close();
    }

    static {
        s_commands.add(0, "uninstall");
        s_commands.add(1, "install");
        s_commands.add(2, "reinstall");
        s_commands.add(3, "user");
        s_commands.add(4, "password");
        s_commands.add(5, "database");
        s_commands.add(6, "host");
        s_commands.add(7, "port");
    }
}

