/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.types.selectors.ExtendFileSelector;

public class ExtendSelector
extends BaseSelector {
    private String classname = null;
    private ExtendFileSelector dynselector = null;
    private Vector paramVec = new Vector();
    private Path classpath = null;

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void selectorCreate() {
        if (this.classname != null && this.classname.length() > 0) {
            try {
                this.dynselector = (ExtendFileSelector)Class.forName(this.classname).newInstance();
            }
            catch (ClassNotFoundException cnfexcept) {
                this.setError("Selector " + this.classname + " not initialized, no such class");
            }
            catch (InstantiationException iexcept) {
                this.setError("Selector " + this.classname + " not initialized, could not create class");
            }
            catch (IllegalAccessException iaexcept) {
                this.setError("Selector " + this.classname + " not initialized, class not accessible");
            }
        } else {
            this.setError("There is no classname specified");
        }
    }

    public void addParam(Parameter p) {
        this.paramVec.addElement(p);
    }

    public final void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public final Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public final Path getClasspath() {
        return this.classpath;
    }

    public void setClasspathref(Reference r) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(r);
    }

    public void verifySettings() {
        if (this.classname == null || this.classname.length() < 1) {
            this.setError("The classname attribute is required");
        } else if (this.dynselector == null) {
            this.setError("Internal Error: The dynamic selector is not set");
        }
    }

    public boolean isSelected(File basedir, String filename, File file) throws BuildException {
        if (this.dynselector == null) {
            this.selectorCreate();
        }
        this.validate();
        if (this.paramVec.size() > 0) {
            Object[] paramArray = new Parameter[this.paramVec.size()];
            this.paramVec.copyInto(paramArray);
            this.dynselector.setParameters((Parameter[])paramArray);
        }
        return this.dynselector.isSelected(basedir, filename, file);
    }
}

