drop table auto_vacuum_stats;
create table auto_vacuum_stats
(
 relname name,
 lival bigint,
 luval bigint,
 ldval bigint,
 vacuum boolean default false
);

CREATE OR REPLACE FUNCTION  markforautovacuum(integer,integer,integer) RETURNS boolean AS '
declare
 it alias for $1;
 ut alias for $2;
 dt alias for $3;

 relation record;

 olival bigint;
 oluval bigint;
 oldval bigint;

 n integer;

begin

 for relation in select relname,n_tup_ins,n_tup_upd,n_tup_del from pg_stat_user_tables loop

 --Check if this is a new table
 select count(*) into n from auto_vacuum_stats where relname=relation.relname;

 if n<=0 then
  insert into auto_vacuum_stats(relname,lival,luval,ldval) values
  (relation.relname,relation.n_tup_ins,relation.n_tup_upd,relation.n_tup_del);
 else
  select lival,luval,ldval into olival,oluval,oldval from auto_vacuum_stats where relname=relation.relname;

  if ((relation.n_tup_ins-olival)>it) OR ((relation.n_tup_upd-oluval)>ut) OR ((relation.n_tup_del-oldval)>dt) then
   update auto_vacuum_stats
    set lival=relation.n_tup_ins,luval=relation.n_tup_upd,ldval=relation.n_tup_del,vacuum=true
    where relname=relation.relname;
  end if;
 end if;

 end loop;

 return true;                                                            	

end;
' LANGUAGE 'plpgsql';

--Create the values
insert into auto_vacuum_stats(relname,lival,luval,ldval) select relname,n_tup_ins,n_tup_upd,n_tup_del from  pg_stat_user_tables;