/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var isDataType = require( './../lib' );

var bool = isDataType( 'binary' );
console.log( bool );
// => true

bool = isDataType( 'float32' );
console.log( bool );
// => true

bool = isDataType( 'float64' );
console.log( bool );
// => true

bool = isDataType( 'generic' );
console.log( bool );
// => true

bool = isDataType( 'int16' );
console.log( bool );
// => true

bool = isDataType( 'int32' );
console.log( bool );
// => true

bool = isDataType( 'int8' );
console.log( bool );
// => true

bool = isDataType( 'uint16' );
console.log( bool );
// => true

bool = isDataType( 'uint32' );
console.log( bool );
// => true

bool = isDataType( 'uint8' );
console.log( bool );
// => true

bool = isDataType( 'uint8c' );
console.log( bool );
// => true

bool = isDataType( '' );
console.log( bool );
// => false

bool = isDataType( 'foo' );
console.log( bool );
// => false
