info = {
    "name": "sr-Latn",
    "date_order": "DMY",
    "january": [
        "jan",
        "januar"
    ],
    "february": [
        "feb",
        "februar"
    ],
    "march": [
        "mar",
        "mart"
    ],
    "april": [
        "apr",
        "april"
    ],
    "may": [
        "maj"
    ],
    "june": [
        "jun"
    ],
    "july": [
        "jul"
    ],
    "august": [
        "avg",
        "avgust"
    ],
    "september": [
        "sep",
        "septembar"
    ],
    "october": [
        "okt",
        "oktobar"
    ],
    "november": [
        "nov",
        "novembar"
    ],
    "december": [
        "dec",
        "decembar"
    ],
    "monday": [
        "pon",
        "ponedeljak"
    ],
    "tuesday": [
        "uto",
        "utorak"
    ],
    "wednesday": [
        "sre",
        "sreda"
    ],
    "thursday": [
        "čet",
        "četvrtak"
    ],
    "friday": [
        "pet",
        "petak"
    ],
    "saturday": [
        "sub",
        "subota"
    ],
    "sunday": [
        "ned",
        "nedelja"
    ],
    "am": [
        "pre podne"
    ],
    "pm": [
        "po podne"
    ],
    "year": [
        "g",
        "god",
        "godina"
    ],
    "month": [
        "m",
        "mes",
        "mesec"
    ],
    "week": [
        "n",
        "ned",
        "nedelja"
    ],
    "day": [
        "d",
        "dan"
    ],
    "hour": [
        "sat",
        "č"
    ],
    "minute": [
        "min",
        "minut"
    ],
    "second": [
        "s",
        "sek",
        "sekund"
    ],
    "relative-type": {
        "0 day ago": [
            "danas"
        ],
        "0 hour ago": [
            "ovog sata"
        ],
        "0 minute ago": [
            "ovog minuta"
        ],
        "0 month ago": [
            "ovog meseca"
        ],
        "0 second ago": [
            "sada"
        ],
        "0 week ago": [
            "ove nedelje"
        ],
        "0 year ago": [
            "ove godine"
        ],
        "1 day ago": [
            "juče"
        ],
        "1 month ago": [
            "prošlog meseca"
        ],
        "1 week ago": [
            "prošle nedelje"
        ],
        "1 year ago": [
            "prošle godine"
        ],
        "in 1 day": [
            "sutra"
        ],
        "in 1 month": [
            "sledećeg meseca"
        ],
        "in 1 week": [
            "sledeće nedelje"
        ],
        "in 1 year": [
            "sledeće godine"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "pre (\\d+[.,]?\\d*) d",
            "pre (\\d+[.,]?\\d*) dana"
        ],
        "\\1 hour ago": [
            "pre (\\d+[.,]?\\d*) sata",
            "pre (\\d+[.,]?\\d*) sati",
            "pre (\\d+[.,]?\\d*) č"
        ],
        "\\1 minute ago": [
            "pre (\\d+[.,]?\\d*) min",
            "pre (\\d+[.,]?\\d*) minuta"
        ],
        "\\1 month ago": [
            "pre (\\d+[.,]?\\d*) m",
            "pre (\\d+[.,]?\\d*) mes",
            "pre (\\d+[.,]?\\d*) meseca",
            "pre (\\d+[.,]?\\d*) meseci"
        ],
        "\\1 second ago": [
            "pre (\\d+[.,]?\\d*) s",
            "pre (\\d+[.,]?\\d*) sek",
            "pre (\\d+[.,]?\\d*) sekunde",
            "pre (\\d+[.,]?\\d*) sekundi"
        ],
        "\\1 week ago": [
            "pre (\\d+[.,]?\\d*) n",
            "pre (\\d+[.,]?\\d*) ned",
            "pre (\\d+[.,]?\\d*) nedelja",
            "pre (\\d+[.,]?\\d*) nedelje"
        ],
        "\\1 year ago": [
            "pre (\\d+[.,]?\\d*) g",
            "pre (\\d+[.,]?\\d*) god",
            "pre (\\d+[.,]?\\d*) godina",
            "pre (\\d+[.,]?\\d*) godine"
        ],
        "in \\1 day": [
            "za (\\d+[.,]?\\d*) d",
            "za (\\d+[.,]?\\d*) dan",
            "za (\\d+[.,]?\\d*) dana"
        ],
        "in \\1 hour": [
            "za (\\d+[.,]?\\d*) sat",
            "za (\\d+[.,]?\\d*) sati",
            "za (\\d+[.,]?\\d*) č"
        ],
        "in \\1 minute": [
            "za (\\d+[.,]?\\d*) min",
            "za (\\d+[.,]?\\d*) minut",
            "za (\\d+[.,]?\\d*) minuta"
        ],
        "in \\1 month": [
            "za (\\d+[.,]?\\d*) m",
            "za (\\d+[.,]?\\d*) mes",
            "za (\\d+[.,]?\\d*) mesec",
            "za (\\d+[.,]?\\d*) meseci"
        ],
        "in \\1 second": [
            "za (\\d+[.,]?\\d*) s",
            "za (\\d+[.,]?\\d*) sek",
            "za (\\d+[.,]?\\d*) sekundi",
            "za (\\d+[.,]?\\d*) sekundu"
        ],
        "in \\1 week": [
            "za (\\d+[.,]?\\d*) n",
            "za (\\d+[.,]?\\d*) ned",
            "za (\\d+[.,]?\\d*) nedelja",
            "za (\\d+[.,]?\\d*) nedelju"
        ],
        "in \\1 year": [
            "za (\\d+[.,]?\\d*) g",
            "za (\\d+[.,]?\\d*) god",
            "za (\\d+[.,]?\\d*) godina",
            "za (\\d+[.,]?\\d*) godinu"
        ]
    },
    "locale_specific": {
        "sr-Latn-BA": {
            "name": "sr-Latn-BA",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "sr",
                "srijeda"
            ],
            "sunday": [
                "nedjelja"
            ],
            "am": [
                "prije podne"
            ]
        },
        "sr-Latn-ME": {
            "name": "sr-Latn-ME",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "sr",
                "srijeda"
            ],
            "sunday": [
                "nedjelja"
            ],
            "am": [
                "prije podne"
            ]
        },
        "sr-Latn-XK": {
            "name": "sr-Latn-XK",
            "september": [
                "sept"
            ],
            "tuesday": [
                "ut"
            ],
            "wednesday": [
                "sr"
            ]
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
